/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.balance;

import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.balance.BalanceTableModel;
import org.chorem.lima.ui.balance.BalanceView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class BalanceViewHandler
implements ServiceListener {
    protected BalanceView view;
    private static final Log log = LogFactory.getLog(BalanceViewHandler.class);
    protected ReportServiceMonitorable reportService;
    protected HttpServerServiceMonitorable httpServerServiceMonitorable;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected String selectedAccounts;
    protected BalanceTableModel model;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected int port;

    protected BalanceViewHandler(BalanceView view) {
        this.view = view;
        this.reportService = LimaServiceFactory.getInstance().getService(ReportServiceMonitorable.class);
        this.port = LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).getHttpPort();
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
        this.refresh();
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
        this.refresh();
    }

    public void setAccountFilter(String accounts) {
        this.selectedAccounts = accounts;
        this.refresh();
    }

    public BalanceTrial getDataList() {
        BalanceTrial results = null;
        try {
            results = this.reportService.generateBalanceTrial(this.selectedBeginDate, this.selectedEndDate, this.selectedAccounts, Boolean.valueOf(false), Boolean.valueOf(this.view.getMovmentedFilter().isSelected()));
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Can't update model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog("Can't get entries list", eee);
        }
        return results;
    }

    public void refresh() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            this.model = this.view.getModelBalanceTable();
            BalanceTrial datasList = this.getDataList();
            this.model.refresh(datasList);
            if (datasList != null) {
                this.view.amountCreditLabel.setText(String.valueOf(datasList.getAmountCredit()));
                this.view.amountDebitLabel.setText(String.valueOf(datasList.getAmountDebit()));
                BigDecimal amountSolde = datasList.getAmountSolde();
                this.view.amountSoldeLabel.setText(String.valueOf(amountSolde));
                if (amountSolde.doubleValue() == 0.0) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.solde"));
                } else if (datasList.getSoldeDebit()) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldedebit"));
                } else {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldecredit"));
                }
            }
        }
    }

    public void createDocument() {
        if (this.selectedBeginDate != null & this.selectedEndDate != null) {
            FormatsEnum selectedEnum = (FormatsEnum)this.view.getDocumentEditor().getSelectedItem();
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.selectedBeginDate) + "&endDate=" + dateFormat.format(this.selectedEndDate) + "&format=" + selectedEnum.getExtension() + "&model=" + DocumentsEnum.BALANCE.getFileName();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

