/*
 * #%L
 * Lima Swing
 * 
 * $Id: LimaServiceFactory.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.2/lima-swing/src/main/java/org/chorem/lima/service/LimaServiceFactory.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.loader.SystemInstance;
import org.chorem.lima.LimaMain;

/**
 * This class is a service factory based on embedded openejb container.
 */
public class LimaServiceFactory {

    /** Log. */
    private static Log log = LogFactory.getLog(LimaServiceFactory.class);

    /** Single instance. */
    private static LimaServiceFactory instance;
    protected HashMap<Class, Object> services = new HashMap<Class, Object>();

    /** JNDI context used to look for EJB. */
    protected static InitialContext ctx;

    /**
     * Init openejb jndi context.
     */
    protected LimaServiceFactory() {

        // TODO EC-20100407 maybe put all options in LimaConfig and allow user to configure it (remove getFlatOptions use)
        Properties props = LimaMain.config.getFlatOptions();

        // Context.INITIAL_CONTEXT_FACTORY is a mandatory option
        // containsKey() does'nt work :(
        if (!props.containsKey(Context.INITIAL_CONTEXT_FACTORY)) {
            throw new RuntimeException("Application configuration is missing mandatory property "
                    + Context.INITIAL_CONTEXT_FACTORY);
        }

        try {
            ctx = new InitialContext(props);
        } catch (NamingException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't initialize initial context", eee);
            }
        }

    }

    /**
     * Return service factory singleton instance.
     * 
     * Init it at first call.
     * 
     * @return singleton instance
     */
    public static LimaServiceFactory getInstance() {
        if (instance == null) {
            instance = new LimaServiceFactory();
        }
        return instance;
    }
    
    public <M> M getService(Class<M> serviceMonitorableClass){
        M result = (M) services.get(serviceMonitorableClass);
        if (result == null) {
            Object ejbHome = null;
            String serviceName = serviceMonitorableClass.getSimpleName().replace("Monitorable", "ImplRemote");
            try {
                ejbHome = ctx.lookup(serviceName);
            } catch (NamingException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't lookup for service : " + serviceName, eee);
                }
            }
            InvocationHandler handler = new ServiceMonitorableHandler(ejbHome);
            result = (M) Proxy.newProxyInstance( serviceMonitorableClass.getClassLoader(), new Class[]{serviceMonitorableClass}, handler);
            
            services.put(serviceMonitorableClass, result);
        }
        return result;
    }


    /**
     * Destroy openejb jndi context.
     * 
     * Code taken from openEJB faq :
     * http://openejb.apache.org/faq.html
     * 
     * @throws Exception when trying to destroy a non existent application
     */
    public void destroy() throws Exception {
        
        // destroy code (only in embedded mode)
        Assembler assembler = SystemInstance.get().getComponent(Assembler.class);
        for (AppInfo appInfo : assembler.getDeployedApplications()) {
            assembler.destroyApplication(appInfo.jarPath);
        }
        OpenEJB.destroy();
    }
}
