/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBooksPane.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/home/EntryBooksPane.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.home;

import static org.nuiton.i18n.I18n._;
import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;

public class EntryBooksPane extends JEditorPane implements HyperlinkListener, ServiceListener {

    private static final long serialVersionUID = 1L;
    
    private static final Log log = LogFactory.getLog(EntryBooksPane.class);
    
    protected HomeView view;
    
    protected EntryBookServiceMonitorable entryBookService;
    
    private static Color redBackground = new Color(0xff, 0xee, 0xee);
    private static Color greenBackground = new Color(0xee, 0xff, 0xee);
    
    public EntryBooksPane(HomeView view) {
        this.view=view;

        entryBookService =
            LimaServiceFactory.getInstance().getService(
                    EntryBookServiceMonitorable.class);
        entryBookService.addListener(this);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        
        //init
        setOpaque(true);
        setContentType("text/html");
        setEditable(false);
        setUI(new BasicEditorPaneUI());
        addHyperlinkListener(this);
        refresh();
    }
    
    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {

        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            
            if (e.getDescription().equals("#entrybookschart")) {
                MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
                ui.getHandler().showEntryBookView(ui);
            }
        }
    }

    public void refresh(){
        
        String htmlBegin = "<font face='sans-serif' size=3>"
            + "<p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        
        try {
            
            List<EntryBook> entryBooks = entryBookService.getAllEntryBooks();
            int ebSize = entryBooks.size();
            if (ebSize>0){
                setBackground(greenBackground);
                String entryBooksString="";
                if (ebSize == 1){
                    entryBooksString = _("lima.home.entrybooks.state.single")
                    + "<br/>" + entryBooks.get(0).getLabel()
                    + "<br/><br/><a href='#entrybookschart'>"
                    + _("lima.home.entrybooks.modify") + "</a>";
                    
                }
                else {
                    entryBooksString = _("lima.home.entrybooks.state1_2.plural")
                    + " " + entryBooks.size() + " "
                    + _("lima.home.entrybooks.state2_2.plural") + "<ul>";
                    for (int i = 0; i < ebSize && i < 3; i++) {
//                    for (EntryBook entryBook : entryBooks) {
                        EntryBook entryBook = entryBooks.get(i);
                        entryBooksString += "<li>"+entryBook.getCode() +
                        " - "+entryBook.getLabel()+"</li>";
                    }
                    if (ebSize > 3) {
                        entryBooksString += "<li> ... </li>";
                    }
                    entryBooksString += "</ul></p><p horizontal-align:'center'>"
                        + "<a href='#entrybookschart'>"
                        + _("lima.home.entrybooks.modify") + "</a>";
                }
                //set Text
                setText(htmlBegin + entryBooksString + htmlEnd);
            }
            else {
                setBackground(redBackground);
                //set Text
                setText(htmlBegin
                    + _("lima.home.entrybooks.nothing")
                    + "<br/><br/><a href='#entrybookschart'>"
                    + _("lima.home.entrybooks.create") +"</a>" + htmlEnd);
            }
            
        } catch (LimaException eee) {
            log.debug("Can't get datas account editor pane home", eee);
        }
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("EntryBook") || methodeName.contains("importAll")
            || methodeName.contains("importAs") || methodeName.contains("importEntries")){
            refresh();
        }    
    }
}
