/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBookSearchComboBox.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/EntryBookSearchComboBox.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.combobox.EntryBookComboBoxModel;
import org.chorem.lima.ui.combobox.EntryBookRenderer;
import org.chorem.lima.util.EntryBookToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class EntryBookSearchComboBox extends JComboBox implements KeyListener, ActionListener {

    private static final long serialVersionUID = 1L;

    private static final Log log =
        LogFactory.getLog(EntryBookSearchComboBox.class);
    
    protected FinancialTransactionSearchViewHandler handler;
    
    public EntryBookSearchComboBox(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        EntryBookComboBoxModel entryBookComboBoxModel = new EntryBookComboBoxModel();
        EntryBookRenderer entryBookRenderer = new EntryBookRenderer();
        setModel(entryBookComboBoxModel);
        setRenderer(entryBookRenderer);
        setEditable(true);
        AutoCompleteDecorator.decorate(this, EntryBookToString.getInstance());
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.addActionListener(this);
    }

    
    
    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof EntryBook){
            handler.setEntryBook((EntryBook) this.getSelectedItem());
        }
    }


    @Override
    public void keyPressed(KeyEvent e) {
        
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof EntryBook){
            handler.setEntryBook((EntryBook) this.getSelectedItem());
        }
        // delegate popup list menu
        if ( e.getKeyChar() == KeyEvent.VK_ENTER )
        {
            firePopupMenuCanceled();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        
    }
    
}
