/*
 * #%L
 * Lima Swing
 * 
 * $Id: AmountSearchPanel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/AmountSearchPanel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.chorem.lima.enums.ComboBoxOperatorsEnum;

public class AmountSearchPanel extends JPanel {
    
    protected FinancialTransactionSearchViewHandler handler;
    
    public AmountSearchPanel(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        refresh(ComboBoxOperatorsEnum.EQUAL);
    }
    
    static final long serialVersionUID = 1L;

    public void refresh(ComboBoxOperatorsEnum enums){
        
        final JTextField amountTextField = new JTextField(16);
        amountTextField.setMinimumSize(amountTextField.getPreferredSize());
        KeyListener amountKeyListener = new KeyListener() {
            
            @Override
            public void keyTyped(KeyEvent e) {                    
            }
            
            @Override
            public void keyReleased(KeyEvent e) {
                String amount = amountTextField.getText();
                //to prevent useless call to service
                if (!amount.equals(handler.getAmount())){
                    handler.setAmount(amount);
                }
            }
            
            @Override
            public void keyPressed(KeyEvent e) {                    
            }
        };
        amountTextField.addKeyListener(amountKeyListener);
        handler.setAmount2("");
        handler.setOperator(enums.getSymbol());
        handler.refresh();
        this.removeAll();
        this.add(amountTextField);
        
        switch (enums) {
        case INTERVAL:
            final JTextField amount2TextField = new JTextField(16);
            amount2TextField.setMinimumSize(amount2TextField.getPreferredSize());
            KeyListener amount2KeyListener = new KeyListener() {
                
                @Override
                public void keyTyped(KeyEvent e) {                    
                }
                
                @Override
                public void keyReleased(KeyEvent e) {
                    
                    String amount2 = amount2TextField.getText();
                    //to prevent useless call to service
                    if (!amount2.equals(handler.getAmount2())){
                        handler.setAmount2(amount2);
                    }
                }
                
                @Override
                public void keyPressed(KeyEvent e) {                    
                }
            };
            amount2TextField.addKeyListener(amount2KeyListener);
            handler.setAmount("");
            this.add(amount2TextField);
            break;
        }
        amountTextField.setText(handler.getAmount());        
    }
    
}
