/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.financialtransaction.*;
import org.chorem.lima.ui.financialtransaction.FinancialPeriodComboBox;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class FinancialTransactionView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8TRxieGJzEpCkfIXyogaZggVDVdShUQgqiIaEmSR1AGKGAL8zuTuKh45ntzCxeOCB+Aj+hvfdSqTdOqIeeOXBB/QtVxaHXindmba832SwW64NtvR/P+8wz77zvb/+gspLoq8c4ihwZck07xFm/vrl5231MPH2DKE/SQAuJ4s9YCZVaaMof2JVGZ1sNk17rpddWRCcQnPCh7MUGOqD0U0ZUmxCt0al0hqdUrTlwL0ZBKPuoA1JZqL+8/7f00n/xawmhKAB2s3CU+Y9lJSfZ30Al6mt0BCo9wTWG+TbQkJRvA99pY1thWKlbuEN+Rs/RRAONB1gCmEZnRj+yxbD5UaDRRPUedhlZ0GhJyG3HawtJOg6jHeyE1NmiHHOPYqYl5gp7mgru1PvGe4nxPiXdILCw4wDaxtxnRGp0syjoaoyUYE8pwqATiH9XdDU6bFRxjFLOshCMYJ5EHu0In7AB8B0iqQB1r2RQ8kTHFa6InB3RK8a+LKINg5QgH+4hKy+B/S4fNgndA3Om2rQ3tcaphvr0GZFwKeds9wBOQEEFJ75MZ1fkELWtoVIN7BIG/WREihzVhU5y1q3RRFcSpbYy+Gk0m8rr23elphQboJ9Kx01VBwALxjSfdu93sfcTiJCquBxqLfiOQE4ibf6fT9sr1V74Qp7zYp7z2zznpTzn5QzndHUdrkkwdgdz87yOp46WuNJZp7cy3oF9obZdNKoXeVAJUNIwJ/esqNH1wsVMkctJs1QbVOmmfcAQYZmANKeHpdkdAVwl+iI1RmFAO8mATiboWAuVZQhmjU60ds/0u+CKp/mJHdPcAFrv/8dm3r76+496f4QfhdqzmaFDGwhGayBFAAOPmtIH4/kdaspqGzhYbKFKPLTseprLINbsuYEc1IuHmkl3VrFqA0R54t3rP489erMPleroABPYr2MTv4Yqui1BBcH8KPh+yTL6rDsJ34cMN3gvGt4LjICrlDPKyTzWsFDcUJNrEcgwlyHDgItb+eu/mebvS30pxoDayT3DEznKD9F4XM3us96qytxfU4EioS+SlZS1pMbM71zQa9kf7Pda1lkniU91v+saUWh+Nixx8++2xflyBJxyJ35rn1/1scbzLuU+dOa1TwechCXtE0mkiXjwqTjG/GPO0c4URjhXGOHCCGpMEG4uyc8R4+vCREZDEDkcvinMoThCrfApLhbmMBpCHodLhTmMhrCZw2FxhMasSNFdJXS7rXOojAI0rYYXWEFWk0rIj001g/MBgZCx8TsNAAA=";
    public static final String PROPERTY$JCOMBO_BOX0 = "$JComboBox0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.financialtransaction.FinancialTransactionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton back;
    protected javax.swing.JLabel financialPeriodLabel;
    protected org.chorem.lima.ui.financialtransaction.FinancialTransactionTable financialTransactionTable;
    protected org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel financialTransactionTableModel;
    protected javax.swing.JComboBox fiscalPeriodComboBox;
    protected javax.swing.JLabel fiscalPeriodLabel;
    protected org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler handler;
    protected org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel modelFinancialPeriod;
    protected org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel modelFiscalPeriod;
    protected javax.swing.JButton next;
    protected java.lang.Boolean selectedRow;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionView $Table0 = this;
    private javax.swing.JComboBox $JComboBox0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    FinancialPeriodComboBox financialPeriodComboBox;
    
        
        
        void $afterCompleteSetup() {
            getHandler().refresh();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionView() {
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        getHandler().deleteSelectedRow();
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().copyRow();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().pasteRow();
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().addFinancialTransaction();
    }

    public void doActionPerformed__on__back(java.awt.event.ActionEvent event) {
        financialPeriodComboBox.back();
    }

    public void doActionPerformed__on__fiscalPeriodComboBox(java.awt.event.ActionEvent event) {
        getModelFinancialPeriod().setFiscalPeriod( (FiscalPeriod) fiscalPeriodComboBox.getSelectedItem());                 getHandler().refresh();
    }

    public void doActionPerformed__on__next(java.awt.event.ActionEvent event) {
        financialPeriodComboBox.next();
    }

    public void doValueChanged__on__$ListSelectionModel0(javax.swing.event.ListSelectionEvent event) {
        setSelectedRow(financialTransactionTable.getSelectedRow() != -1);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getHandler().addEmptyEntry();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getBack() {
        return back;
    }

    public javax.swing.JLabel getFinancialPeriodLabel() {
        return financialPeriodLabel;
    }

    public org.chorem.lima.ui.financialtransaction.FinancialTransactionTable getFinancialTransactionTable() {
        return financialTransactionTable;
    }

    public org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel getFinancialTransactionTableModel() {
        return financialTransactionTableModel;
    }

    public javax.swing.JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public javax.swing.JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler getHandler() {
        return handler;
    }

    public org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel getModelFinancialPeriod() {
        return modelFinancialPeriod;
    }

    public org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel getModelFiscalPeriod() {
        return modelFiscalPeriod;
    }

    public javax.swing.JButton getNext() {
        return next;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$JComboBox0(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.$JComboBox0;
        this.$JComboBox0 = newValue;
        firePropertyChange(PROPERTY$JCOMBO_BOX0, oldValue, newValue);
    }

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler newValue) {
        org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox get$JComboBox0() {
        return $JComboBox0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBack() {
        $objectMap.put("back", back = new javax.swing.JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createFinancialPeriodLabel() {
        $objectMap.put("financialPeriodLabel", financialPeriodLabel = new javax.swing.JLabel());
        
        financialPeriodLabel.setName("financialPeriodLabel");
        financialPeriodLabel.setText(_("lima.common.period"));
    }

    protected void createFinancialTransactionTable() {
        $objectMap.put("financialTransactionTable", financialTransactionTable = new org.chorem.lima.ui.financialtransaction.FinancialTransactionTable(getHandler()));
        
        financialTransactionTable.setName("financialTransactionTable");
        financialTransactionTable.setRowHeight(22);
        financialTransactionTable.setSortable(false);
    }

    protected void createFinancialTransactionTableModel() {
        $objectMap.put("financialTransactionTableModel", financialTransactionTableModel = new org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new javax.swing.JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setEditable(false);
        fiscalPeriodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new javax.swing.JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
        fiscalPeriodLabel.setText(_("lima.charts.fiscalyear"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionViewHandler(this));
    }

    protected void createModelFinancialPeriod() {
        $objectMap.put("modelFinancialPeriod", modelFinancialPeriod = new org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel());
    }

    protected void createModelFiscalPeriod() {
        $objectMap.put("modelFiscalPeriod", modelFiscalPeriod = new org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel());
    }

    protected void createNext() {
        $objectMap.put("next", next = new javax.swing.JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add(fiscalPeriodLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(fiscalPeriodComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialPeriodLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JComboBox0, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(back, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(next, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton2, new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton3, new GridBagConstraints(9, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton4, new GridBagConstraints(10, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 11, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionTable);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        fiscalPeriodComboBox.setModel(getModelFiscalPeriod());
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer());
        financialTransactionTable.setModel(getFinancialTransactionTableModel());
        financialTransactionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        createModelFinancialPeriod();
        createModelFiscalPeriod();
        financialPeriodComboBox = new FinancialPeriodComboBox(handler);
        createFiscalPeriodLabel();
        createFiscalPeriodComboBox();
        createFinancialPeriodLabel();
        // inline creation of $JComboBox0
        $objectMap.put("$JComboBox0", $JComboBox0 = financialPeriodComboBox);
        
        $JComboBox0.setName("$JComboBox0");
        createBack();
        createNext();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.copy"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("lima.common.paste"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("lima.entries.addTransaction"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("lima.entries.addEntry"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("lima.common.remove"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionTableModel();
        createFinancialTransactionTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setEnabled(isSelectedRow());
            }
        });
    }

}