/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.financialstatementchart;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.financialstatementchart.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class FinancialStatementChartView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED = "addFinancialStatementMovement.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UQU8TQRSeVkotBVRQxAAKgvHkVhONBwgiaIPYqqHEEHtxujt2B6Y768wsXS/Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa3+y23ZYu0KQ26W4z733f++bre+/dT5SSAs3tYN83hOcoWiPGxu3t7YeVHWKqO0SagrqKCxR+EkmULKOs1TqXCs2XCxqea8Bza7zmcoc4bejFAhqS6gUj0iZEKTTTiTClzJVa4UXf9USTtSUqjvXN71/J19art0mEfBfUDcNVZo9CRTcZKKAktRQag0p7OMewUwUZgjpV0Duiz9YYlvIBrpHn6CVKF9CgiwWQKXSx9ysHHAHedxVKL2zhCiNXFcpzUTVMmwtSMxitYcOjxjPqYMekmEmFFakBoWljoYx887zUPF/T548pqbtuQD4I1DZ2LEaEQsX/Q70e8kUVspIw6ApibfK6Qqe0Q4Z2zVjlnBHsRJkjCxslU3DGHmFHX/aszvUNWQdzjbaQTs+0UBklCAn8UeiCvsMONNqu4m4I9I2N7a1mhoaMtZCnFwpUqlIgj3KnyC3CoOz59rLdGZHeKWxZ3U6sE2xpP8c71K96SnGnU/lMLL7I94K3TprpBAx7rgVZEdf+OPx3gD44TqHjhDownjVtYu52hwWa6hgQGD0jGr1oNhJllBIeHCs0We6e1k0IhXM6uW9ONWEQ/Tsx/u3jjw/59uE8E5vatltgaFzBXTCd6tInwsn0FGW5InYXyygTtmCweKZjhJUaYRAH9cIW1XBjHUsbKFLp758+Tzz9egwl82iIcWzlsc6/B81nC3CBM8t3b60Eiobrx+F5UmsDx21atRl8FdHFR5fg/8OzFepY0BXLPlgxHWNFS08l8+XPeOn9StOOBMg7d2B6ZEnqCRqkDqMOCbZVYxHFbqesK4ln8WjhxK2ghH5PuI3WvxI8r8Xdd0S2z4pOu+57+nUjUK9/3eyZbLQ12cHg9ck2oIgPS3hsKTRmFivY2hVPkeV4zukeONPE0fKsQ6RdOJJGH9/Vj3w/DPcP0TDXt4beGA7TMN+3hv4ZLvXNcBkY/gHl6ATo/wgAAA==";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton addFinancialStatementHeader;
    protected javax.swing.JButton addFinancialStatementMovement;
    protected javax.swing.JButton checkButton;
    protected org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler handler;
    protected javax.swing.JButton importButton;
    protected javax.swing.JButton removeButton;
    protected java.lang.Boolean selectedRow;
    protected org.jdesktop.swingx.JXTreeTable treeTable;
    protected javax.swing.JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialStatementChartView $Table0 = this;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementChartView() {
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFinancialStatementHeader(java.awt.event.ActionEvent event) {
        getHandler().addFinancialStatementHeader();
    }

    public void doActionPerformed__on__addFinancialStatementMovement(java.awt.event.ActionEvent event) {
        getHandler().addFinancialStatementMovement();
    }

    public void doActionPerformed__on__checkButton(java.awt.event.ActionEvent event) {
        getHandler().financialStatementChartCheck();
    }

    public void doActionPerformed__on__importButton(java.awt.event.ActionEvent event) {
        getHandler().importFinancialStatementChart();
    }

    public void doActionPerformed__on__removeButton(java.awt.event.ActionEvent event) {
        getHandler().removeFinancialStatement();
    }

    public void doActionPerformed__on__updateButton(java.awt.event.ActionEvent event) {
        getHandler().updateFinancialStatement();
    }

    public void doValueChanged__on__$ListSelectionModel0(javax.swing.event.ListSelectionEvent event) {
        setSelectedRow(treeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getAddFinancialStatementHeader() {
        return addFinancialStatementHeader;
    }

    public javax.swing.JButton getAddFinancialStatementMovement() {
        return addFinancialStatementMovement;
    }

    public javax.swing.JButton getCheckButton() {
        return checkButton;
    }

    public org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler getHandler() {
        return handler;
    }

    public javax.swing.JButton getImportButton() {
        return importButton;
    }

    public javax.swing.JButton getRemoveButton() {
        return removeButton;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public org.jdesktop.swingx.JXTreeTable getTreeTable() {
        return treeTable;
    }

    public javax.swing.JButton getUpdateButton() {
        return updateButton;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler newValue) {
        org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddFinancialStatementHeader() {
        $objectMap.put("addFinancialStatementHeader", addFinancialStatementHeader = new javax.swing.JButton());
        
        addFinancialStatementHeader.setName("addFinancialStatementHeader");
        addFinancialStatementHeader.setText(_("lima.financialstatement.header.add"));
        addFinancialStatementHeader.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementHeader"));
    }

    protected void createAddFinancialStatementMovement() {
        $objectMap.put("addFinancialStatementMovement", addFinancialStatementMovement = new javax.swing.JButton());
        
        addFinancialStatementMovement.setName("addFinancialStatementMovement");
        addFinancialStatementMovement.setText(_("lima.financialstatement.movement.add"));
        addFinancialStatementMovement.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementMovement"));
    }

    protected void createCheckButton() {
        $objectMap.put("checkButton", checkButton = new javax.swing.JButton());
        
        checkButton.setName("checkButton");
        checkButton.setText(_("lima.financialstatement.check"));
        checkButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__checkButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialStatementChartViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new javax.swing.JButton());
        
        importButton.setName("importButton");
        importButton.setText(_("lima.importexport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new javax.swing.JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(_("lima.common.remove"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createTreeTable() {
        $objectMap.put("treeTable", treeTable = new org.jdesktop.swingx.JXTreeTable());
        
        treeTable.setName("treeTable");
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new javax.swing.JButton());
        
        updateButton.setName("updateButton");
        updateButton.setText(_("lima.common.update"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 6, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addFinancialStatementHeader, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(addFinancialStatementMovement, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(updateButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(removeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(importButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(checkButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(treeTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        treeTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        treeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        treeTable.setTreeTableModel(new org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTableModel());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTreeTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createAddFinancialStatementHeader();
        createAddFinancialStatementMovement();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        createCheckButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addFinancialStatementMovement.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}