/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBooksReportsTableModel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/entrybooksreports/EntryBooksReportsTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybooksreports;

import static org.nuiton.i18n.I18n._;
import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Entry;


/**
 * Entry book table model.
 * By : $Author: echatellier $
 */
public class EntryBooksReportsTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** log. */
    private static final Log log = LogFactory.getLog(EntryBooksReportsTableModel.class);
    
    /** data cache */
    protected ReportsDatas cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        
        // just prevent too much result
        if (cacheDataList != null && cacheDataList.getListEntry() != null) {
            result = cacheDataList.getListEntry().size();
        }

        return result;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.table.date");
                break;
            case 1:
                res = _("lima.table.account");
                break;
            case 2:
                res = _("lima.table.voucher");
                break;
            case 3:
                res = _("lima.table.description");
                break;
            case 4:
                res = _("lima.table.letter");
                break;  
            case 5:
                res = _("lima.table.debit");
                break;
            case 6:
                res = _("lima.table.credit");
                break;
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if(cacheDataList.getListEntry() != null) {
            Entry currentRow = cacheDataList.getListEntry().get(row);
            SimpleDateFormat simpleDateFormat =
                new SimpleDateFormat("dd MMMMM yyyy");   
                        
            switch (column) {
                case 0:
                    result = simpleDateFormat.
                    format(currentRow.getFinancialTransaction().getTransactionDate());
                    break;
                case 1:
                    if (currentRow.getAccount() != null){
                        result = currentRow.getAccount().getAccountNumber();
                    }
                    else {
                        result = null;
                    }
                    break;
                case 2:
                    result = currentRow.getVoucher();
                    break;
                case 3:
                    result = currentRow.getDescription();
                    break;
                case 4:
                    if (currentRow.getLetter() != null){
                        result = currentRow.getLetter().getCode();
                    }
                    else {
                        result = null;
                    }
                    break;
                case 5:
                    result = currentRow.getDebit() ? currentRow.getAmount() : 0;
                    break;
                case 6:
                    result = currentRow.getDebit() ? 0 : currentRow.getAmount();
                    break;
            }
        } 
        else {
            if (log.isDebugEnabled()) {
                log.debug("No EntryBook selected skip table model update");
            }
        }

        return result;
    }

    public Entry getElementAt(int row){
        return cacheDataList.getListEntry().get(row);
    }
    

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        // Just read, no write
        return false;
    }
    
    public void refresh(ReportsDatas datasList){
        cacheDataList = datasList;
        fireTableDataChanged();
    }
    
}
