/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBookTableModel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/entrybook/EntryBookTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybook;

import static org.nuiton.i18n.I18n._;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * Entry book table model.
 * 
 * @author ore
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class EntryBookTableModel extends AbstractTableModel implements ServiceListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7578692417919755647L;

    /** log. */
    private static final Log log = LogFactory.getLog(EntryBookTableModel.class);

    /** Services. */
    protected EntryBookServiceMonitorable entryBookService;

    /**
     * Constructor.
     */
    public EntryBookTableModel() {
        entryBookService =
            LimaServiceFactory.getInstance().getService(
                    EntryBookServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener(this);
        }

    @Override
    public int getRowCount() {
        int result = 0;
        
        try {
            result = entryBookService.getAllEntryBooks().size();
        } catch (LimaException e) {
            if (log.isDebugEnabled()){
                log.debug("Can't get all entrybooks",e);
            }
        }
        
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.table.code");
                break;
            case 1:
                res = _("lima.table.label");
                break;
        }
        return res;
    }

    public EntryBook getEntryBookAtRow(int row) throws LimaException {
        EntryBook entryBook = null;
        entryBook = entryBookService.getAllEntryBooks().get(row);
        
        return entryBook;
    }

    @Override
    public Object getValueAt(int row, int column) {

        Object result = null;
        try {
            EntryBook entryBook = getEntryBookAtRow(row);

            switch (column) {
                case 0:
                    result = entryBook.getCode();
                    break;
                case 1:
                    result = entryBook.getLabel();
                    break;
            }
        } catch (LimaException eee) {
            if (log.isDebugEnabled()){
                log.debug("Can't get EntryBook",eee);
            }
        }

        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        // Ne cells editable
        return false;
    }

    /**
     * @param entryBook
     * @throws LimaException 
     */
    public void addEntryBook(EntryBook entryBook) throws LimaException {
        /* Calling journal service */
        entryBookService.createEntryBook(entryBook);
        int row = entryBookService.getAllEntryBooks().indexOf(entryBook);
        fireTableRowsInserted(row, row);
    }

    /**
     * 
     * @param entryBook
     * @throws LimaException
     */
    public void updateEntryBook(EntryBook entryBook) throws LimaException {
        /* Calling journal service */
        entryBookService.updateEntryBook(entryBook);
        int row = entryBookService.getAllEntryBooks().indexOf(entryBook);
        fireTableRowsUpdated(row, row);
    }

    /**
     * 
     * @param entryBook
     * @throws LimaException 
     */
    public void removeEntryBook(EntryBook entryBook) throws LimaException {
        /* Calling journal service */
        int row = entryBookService.getAllEntryBooks().indexOf(entryBook);
        entryBookService.removeEntryBook(entryBook);
        fireTableRowsDeleted(row, row);
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        
        //refresh on import datas
        if (methodeName.contains("importEntryBooks")
                || methodeName.contains("importAll")
                || methodeName.contains("importAs")){
            fireTableDataChanged();
        }
    }
}
