/*
 * #%L
 * Lima Swing
 * 
 * $Id: ComboBoxLetterEnum.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/enums/ComboBoxLetterEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n._;


public enum ComboBoxLetterEnum {

    ALL(_("lima.enum.comboboxletter.all")),
    SELECT_ONE(_("lima.enum.comboboxletter.selectone"));
    
    private final String description;
    
    private ComboBoxLetterEnum(String description) {
        this.description = description;
    }
    
    public String getDescription() {
    return this.description;
    }
    
    public static String[] descriptions(){
        int nbElts = ComboBoxLetterEnum.values().length;
        String[] descriptions = new String[nbElts];
        ComboBoxLetterEnum[] enums = ComboBoxLetterEnum.values();
        for (int i = 0; i < nbElts; i++) {
            descriptions[i] = enums[i].getDescription();
        }
        return descriptions;
    }
    
    public static ComboBoxLetterEnum valueOfDescription(String description){
        ComboBoxLetterEnum value = null;
        
        for (ComboBoxLetterEnum enums : ComboBoxLetterEnum.values()) {
            if (description.equals(enums.description)){
                value = enums;
                break;
            }
        }
        return value;
    }
}
