/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class EntryBooksPane
extends JEditorPane
implements HyperlinkListener,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EntryBooksPane.class);
    protected HomeView view;
    protected EntryBookServiceMonitorable entryBookService;
    private static Color redBackground = new Color(255, 238, 238);
    private static Color greenBackground = new Color(238, 255, 238);

    public EntryBooksPane(HomeView view) {
        this.view = view;
        this.entryBookService = LimaServiceFactory.getInstance().getService(EntryBookServiceMonitorable.class);
        this.entryBookService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.setOpaque(true);
        this.setContentType("text/html");
        this.setEditable(false);
        this.setUI(new BasicEditorPaneUI());
        this.addHyperlinkListener(this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription().equals("#entrybookschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showEntryBookView((JAXXContext)ui);
        }
    }

    public void refresh() {
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List entryBooks = this.entryBookService.getAllEntryBooks();
            int ebSize = entryBooks.size();
            if (ebSize > 0) {
                this.setBackground(greenBackground);
                String entryBooksString = "";
                if (ebSize == 1) {
                    entryBooksString = I18n._((String)"lima.home.entrybooks.state.single") + "<br/>" + entryBooks.get(0) + "<br/><br/><a href='#entrybookschart'>" + I18n._((String)"lima.home.entrybooks.modify") + "</a>";
                } else {
                    entryBooksString = I18n._((String)"lima.home.entrybooks.state1_2.plural") + " " + entryBooks.size() + " " + I18n._((String)"lima.home.entrybooks.state2_2.plural") + "<ul>";
                    for (EntryBook entryBook : entryBooks) {
                        entryBooksString = entryBooksString + "<li>" + entryBook.getCode() + " - " + entryBook.getLabel() + "</li>";
                    }
                    entryBooksString = entryBooksString + "</ul></p><p horizontal-align:'center'><a href='#entrybookschart'>" + I18n._((String)"lima.home.entrybooks.modify") + "</a>";
                }
                this.setText(htmlBegin + entryBooksString + htmlEnd);
            } else {
                this.setBackground(redBackground);
                this.setText(htmlBegin + I18n._((String)"lima.home.entrybooks.nothing") + "<br/><br/><a href='#entrybookschart'>" + I18n._((String)"lima.home.entrybooks.create") + "</a>" + htmlEnd);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas account editor pane home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("EntryBook") || methodeName.contains("importAll") || methodeName.contains("importAs") || methodeName.contains("importEntries")) {
            this.refresh();
        }
    }
}

