/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

public class FinancialPeriodComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);
    protected Object selectedFinancialPeriod;
    protected List<FinancialPeriod> datasCache;
    protected FinancialPeriodServiceMonitorable financialPeriodService = LimaServiceFactory.getInstance().getService(FinancialPeriodServiceMonitorable.class);
    protected FiscalPeriod selectedFiscalPeriod;

    public FinancialPeriodComboBoxModel() {
        this.financialPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
        this.datasCache = this.getDataList();
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedFinancialPeriod = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedFinancialPeriod;
    }

    public List<FinancialPeriod> getDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.selectedFiscalPeriod != null ? (List)this.selectedFiscalPeriod.getFinancialPeriod() : this.financialPeriodService.getUnblockedFinancialPeriods();
            }
            catch (LimaException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get Financial Period list", (Throwable)ex);
            }
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("Period") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

