/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.util;

import static org.nuiton.i18n.I18n._;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.nuiton.util.Resource;

/**
 * @author ore
 * @author Rémi Chapelet 
 */
public class DialogHelper {

    public static int showConfirmDialog(String message) {
        String[] response = {_("lima.response.yes"), _("lima.response.no")};
        return JOptionPane.showOptionDialog(null,
                message,
                _("lima.common.question"),
                JOptionPane.YES_NO_OPTION,
                JOptionPane.QUESTION_MESSAGE,
                null, //do not use a custom Icon
                response, //the titles of buttons
                response[0]); //default button title
    }

    public static void showMessageDialog(String message) {
        JFrame f = new JFrame();
        f.setIconImage(Resource.getIcon("icons/lima.png").getImage());
        JOptionPane.showMessageDialog(
                f,
                message,
                _("lima.common.error"),
                JOptionPane.ERROR_MESSAGE);
        f.dispose();
    }

    /**
     * Permet d'afficher une boite de dialogue.
     * @param message
     * @param titre
     * @param type
     */
    public static void showMessageDialog (String message,String titre,int type) {
        JFrame f = new JFrame();
        f.setIconImage(Resource.getIcon("icons/lima.png").getImage());
        JOptionPane.showMessageDialog(
                f,
                message,
                titre,
                type);
        f.dispose();
    }
    
    /**
     * Permet d'afficher une boite de dialogue avec rapport
     * @param message
     * @param titre
     * @param type
     */
    public static void showReportDialog (String message, String title, Component parent) {
    	ReportDialogView reportDialogView = new ReportDialogView();
    	reportDialogView.setIconImage(Resource.getIcon("icons/lima.png").getImage());
    	JTextArea textArea = reportDialogView.getTextArea();    	
    	textArea.setText(message);
    	reportDialogView.setSize(600,400);
    	reportDialogView.setTitle(title);
    	reportDialogView.setLocationRelativeTo(parent);
    	reportDialogView.setVisible(true);
    }

    
}
