/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.fiscalperiod;

import static org.nuiton.i18n.I18n._;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 3015 $
 * 
 * Last update : $Date: 2010-08-23 18:38:53 +0200 (Lun, 23 aoû 2010) $
 * By : $Author: jpepin $
 */
public class FiscalPeriodTableModel extends AbstractTableModel implements ServiceListener{

    /** serialVersionUID. */
    private static final long serialVersionUID = 77027335135838258L;

    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);

    protected FiscalPeriodServiceMonitorable fiscalPeriodService;

    public FiscalPeriodTableModel() {
        fiscalPeriodService =
        	LimaServiceFactory.getInstance().getService(
        			FiscalPeriodServiceMonitorable.class);
        fiscalPeriodService.addListener(this);
        	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
        }

    @Override
    public int getRowCount() {
        
        int result = 0;
        try {
            result = fiscalPeriodService.getAllFiscalPeriods().size();
        }
        catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't get row count",eee);
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    
    public Object getElementAt(int row){
        
        Object currentRow=null;
        try {
            currentRow = fiscalPeriodService.getAllFiscalPeriods().get(row);
        } catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't get elenment at table",eee);
            }
        }
        return currentRow;
    }
    
    @Override
    public String getColumnName(int columnIndex) {
        
        String result = "n/a";
        
        switch(columnIndex) {
        case 0 :
            result = _("lima.table.fiscalperiod");
            break;
        case 1:
            result = _("lima.table.closure");
            break;
        }

        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        // both String
        return String.class;
    }


    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        Object result = "n/a";

        List<FiscalPeriod> periods;
        try {
            periods = fiscalPeriodService.getAllFiscalPeriods();
            FiscalPeriod fiscalPeriod = periods.get(rowIndex);
            
            if (fiscalPeriod != null){
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");                

                switch (columnIndex) {
                case 0:
                    result = simpleDateFormat.
                            format(fiscalPeriod.getBeginDate())
                        + " - " + simpleDateFormat.
                                format(fiscalPeriod.getEndDate());
                    break;
                case 1:
                    if(fiscalPeriod.getLocked()){
                        result = _("lima.common.closed");
                    }
                    else{
                        result = _("lima.common.open");
                    }
                    break;
                }
            }
            


        } catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't update table",eee);
            }
        }

        return result;
    }
    
    public FiscalPeriod getFiscalPeriodAtRow(int row) throws LimaException {
        FiscalPeriod fiscalPeriod = null;
        fiscalPeriod = fiscalPeriodService.getAllFiscalPeriods().get(row);        
        return fiscalPeriod;
    }
    
    /**
     * @param period
     */
    public void addFiscalPeriod(FiscalPeriod period) throws LimaException {

        int currentRowCount = getRowCount();
        
        // Calling fiscal period service
        fiscalPeriodService.createFiscalPeriod(period);
        fireTableRowsInserted(currentRowCount, currentRowCount);
    }
    
    public void blockFiscalPeriod(FiscalPeriod fiscalPeriod) throws LimaException {

        fiscalPeriodService.blockFiscalPeriod(fiscalPeriod);
        fireTableDataChanged();
    }

	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		//refresh on import datas
		if (methodeName.contains("importAll")){
	    	fireTableDataChanged();
		}		
	}
}
