/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialstatementreport;

import org.chorem.lima.business.utils.FormatsEnum;



/**
 * Handler associated with accounts reports view.
 * 
 * @author chatellier
 * @version $Revision: 2884 $
 * 
 * Last update : $Date: 2010-05-06 11:57:19 +0200 (jeu. 06 mai 2010) $
 * By : $Author: jpepin $
 */
public class FinancialStatementReportViewHandler {

    protected FinancialStatementReportView view;
    
    protected FinancialStatementReportTableModel model;
        
    protected FinancialStatementReportViewHandler(FinancialStatementReportView view) {
        this.view = view;
    }
    
    public void refresh(){
        model = view.getModelTable();
        model.refresh();  
    }
    
    public FinancialStatementReportView getView() {
        return view;
    }
    
    public void createDocument() {
    	
    	model = view.getModelTable();
    	FormatsEnum selectedEnum = (FormatsEnum) view.getDocumentEditor().getSelectedItem();
    	model.createDocument(selectedEnum);

    }
}
