/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.balance;

import static org.nuiton.i18n.I18n._;
import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;


/**
 * Handler associated with accounts reports view.
 * By : $Author: jpepin $
 */
public class BalanceViewHandler implements ServiceListener {

    protected BalanceView view;
    
    /** log. */
    private static final Log log = LogFactory.getLog(BalanceViewHandler.class);
    
    /** Services. */
    protected ReportServiceMonitorable reportService;
    protected HttpServerServiceMonitorable httpServerServiceMonitorable;
    
    /** DatePicker Begin Date. */
    protected Date selectedBeginDate;
    
    /** DatePicker EndDate. */
    protected Date selectedEndDate;
    
    /** Text field Accounts */
    protected String selectedAccounts;

    protected BalanceTableModel model;
    
    private static SimpleDateFormat dateFormat =
    	new SimpleDateFormat("yyyy-MM-dd");
    
    protected int port;
    
    protected BalanceViewHandler(BalanceView view) {
        this.view = view;
        
        reportService =
        	LimaServiceFactory.getInstance().getService(
        			ReportServiceMonitorable.class);
        port = LimaServiceFactory.getInstance().getService(
        		HttpServerServiceMonitorable.class).getHttpPort();
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			FinancialTransactionServiceMonitorable.class).addListener(this);
    }
    
    public void setBeginDate(Date date){
        selectedBeginDate = date;
        refresh();
    }
    
    public void setEndDate(Date date){
        selectedEndDate = date;
        refresh();
    }
    
    public void setAccountFilter(String accounts) {
        selectedAccounts = accounts;
        refresh();
    }
    
    /**
     * get all account fot the selected period
     * @return
     */
    public BalanceTrial getDataList(){
        BalanceTrial results = null;
        
        try {
            results = reportService.generateBalanceTrial(selectedBeginDate, selectedEndDate, selectedAccounts, false, view.getMovmentedFilter().isSelected());
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug("Can't update model", eee);
            }
            ErrorHelper.showErrorDialog("Can't get entries list", eee);
        }
        return results;
    }
    
    public void refresh(){
    	
    	if (selectedBeginDate != null && selectedEndDate != null){
	        model = view.getModelBalanceTable();
	        BalanceTrial datasList = getDataList();
	        model.refresh(datasList);
	
	    /**
	     * update the labels credit, debit, solde on the footer 
	     * get all entries for all accounts on the selected period
	     */
	        
	        if (datasList != null){
	            // set amounts credit, debit and solde
	            view.amountCreditLabel.setText(
	            		String.valueOf(datasList.getAmountCredit()));
	            view.amountDebitLabel.setText(
	            		String.valueOf(datasList.getAmountDebit()));            
	            BigDecimal amountSolde = datasList.getAmountSolde();
	            view.amountSoldeLabel.setText(
	            		String.valueOf(amountSolde));
	            
	            
	            if (amountSolde.doubleValue() == 0){
	                view.soldeLabel.setText(_("lima.common.solde"));
	            }
	            else {
	                // set label solde: credit or debit
	                if (datasList.getSoldeDebit()) {
	                    view.soldeLabel.setText(_("lima.common.soldedebit"));
	                }
	                else {
	                    view.soldeLabel.setText(_("lima.common.soldecredit"));
	                }
	            }
	        }
    	}
    }
    
    public void createDocument() {
    	
    	if (selectedBeginDate != null & selectedEndDate != null){
	    	FormatsEnum selectedEnum = (FormatsEnum) view.getDocumentEditor().getSelectedItem();
	    	String address = LimaConfig.getInstance().getHostAdress();
	    	
	    	try {
	    		String url = "http://"+address+":"+port+"/?beginDate="
	    		+dateFormat.format(selectedBeginDate)
	    		+"&endDate="+dateFormat.format(selectedEndDate)+"&format="
	    		+selectedEnum.getExtension()+"&model="
	    		+ DocumentsEnum.BALANCE.getFileName();
	    		Desktop.getDesktop().browse(new URI(url));    		
			} catch (IOException e) {
				log.error("Can't open browser", e);
			} catch (URISyntaxException e) {
				log.error("Can't create news URI", e);
			}
    	}
    }
    
	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")){
			refresh();
		}
	}
}
