/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;

public class ServiceMonitorableHandler implements InvocationHandler {

    private static final Log log = LogFactory.getLog(ServiceMonitorableHandler.class);
	
	private Object service;
	private List<ServiceListener> listeners;
	
	public ServiceMonitorableHandler(Object service){
		this.service = service;
		listeners = new ArrayList<ServiceListener>();
	}
	
	public void addServiceListener(ServiceListener serviceListener){
		listeners.add(serviceListener);
	}

	public void removeServiceListener(ServiceListener serviceListener){
		listeners.remove(serviceListener);
	}
	
	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		Object result = null;
		if (method.getName().equals("addListener")){
			addServiceListener((ServiceListener) args[0]);
		}
		else if (method.getName().equals("removeListener")){
			removeServiceListener((ServiceListener) args[0]);
		}
		else {
			try {
			result = method.invoke(service, args);
			}catch (InvocationTargetException eee){
				throw eee.getCause();
			}
			if (!method.getName().startsWith("get")){
				for (ServiceListener serviceListener : listeners) {
					serviceListener.notifyMethod(service.toString(), method.getName());
					log.debug("proxy : " + service.toString() + " " + method.getName());
				}
			}
		}
		return result;
	}

}
