/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.chorem.lima.service.neogia.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.*;
import org.chorem.lima.dto.util.DTOHelper;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.wrappers.xsd.*;

import java.util.LinkedList;
import java.util.List;

/**
 * @author ore
 */
public class NeogiaUtil {

    /**
     * log
     */
    private static final Log log = LogFactory.getLog(NeogiaUtil.class);
    /**
     * Neogia status
     */
    private static final String ATS_WIP = "ATS_WIP";
    private static final String ATS_BALANCED = "ATS_BALANCED";
    private static final String ATS_FINALIZED = "ATS_FINALIZED";
    private static final String PS_OPEN = "PS_OPEN";
    private static final String PS_CLOSETMP = "PS_CLOSETMP";
    private static final String PS_CLOSE = "PS_CLOSE";

    public static StatusDTO mapToStatusDTO(GenericValueStatusItem value) {
        return new StatusDTO(
                value.getStatusId(),
                findStatusType(value.getStatusId()),
                value.getDescription());
    }

    public static String findStatusType(String id) {
        /**
         * Transaction status
         */
        if (id.equals(ATS_WIP)) {
            return ServiceHelper.TR_WIP;
        }
        if (id.equals(ATS_BALANCED)) {
            return ServiceHelper.TR_BALANCED;
        }
        if (id.equals(ATS_FINALIZED)) {
            return ServiceHelper.TR_FINALIZED;
        }

        /**
         * Period status
         */
        if (id.equals(PS_OPEN)) {
            return ServiceHelper.PE_OPEN;
        }
        if (id.equals(PS_CLOSETMP)) {
            return ServiceHelper.PE_CLOSETMP;
        }
        if (id.equals(PS_CLOSE)) {
            return ServiceHelper.PE_CLOSE;
        }

        log.warn("Can't find status type of StatusDTO");
        return null;
    }

    public static TransactionDTO mapToTransactionDTO(
            GenericValueAcctgTransactionItemAndGlPeriod value,
            List<PeriodDTO> periods,
            List<JournalDTO> journals,
            List<StatusDTO> status) {
        return new TransactionDTO(
                value.getSequenceId(),
                value.getAtranIdName(),
                value.getEntryDate() != null ? value.getEntryDate().getTime() : null,
                value.getVoucherRef(),
                value.getDescription(),
                ServiceHelper.findJournalById(journals, value.getAtrnstypIdName()),
                new LinkedList<EntryDTO>(),
                ServiceHelper.findPeriodById(periods, value.getIdNum()),
                //*****
                // HACK         ServiceHelper.findStatusById(status,value.getATrStatusStatusId()));
                //***** 
                ServiceHelper.findStatusById(status, value.getVoucherContentId()));
    }

    /**
     * @param value
     * @return
     */
    public static JournalDTO mapToJournalDTO(GenericValueAcctgTransactionType value) {
        return new JournalDTO(
                "0",
                value.getIdName(),
                value.getDescription(),
                //*****
                // HACK         value.getATrItPrefix());
                //*****                
                value.getAentfrmEnumId());
    }

    /**
     * @param account
     * @return
     */
    public static Long getLowLevelCode(AccountDTO account) {
        return new Long(getParentsCount(account) - 1);
    }

    public static PeriodDTO mapToPeriodDTO(List<StatusDTO> status, GenericValueGlPeriod value) {
        return new PeriodDTO(
                value.getIdNum(),
                value.getIdName(),
                value.getFromDate().getTime(),
                value.getThruDate().getTime(),
                value.getParentPeriodIdNum() == null ? new LinkedList<PeriodDTO>() : null,
                value.getParentPeriodIdNum() == null ? null : new PeriodDTO(value.getParentPeriodIdNum(), null, null, null, null, null, null),
                ServiceHelper.findStatusById(status, value.getPeriodStatusStatusId()));
    }

    /**
     * @param account
     * @return
     */
    private static int getParentsCount(AccountDTO account) {
        if (account.getParent() == null) {
            // end
            return 0;
        } else {
            return 1 + getParentsCount(account.getParent());
        }
    }

    /**
     * @param account
     * @return
     */
    public static String getTreePath(AccountDTO account) {
        List<String> pathList = getPathList(account);
        String res = "GL_STD_ROLLUP#";
        for (int i = 0; i < pathList.size(); i++) {
            String s = pathList.get(i);
            if (!s.equals("0")) {
                if (i != 0) {
                    res = res + "|";
                }
                res = res + s;
            }
        }
        res = res + "#";
        return res;
    }

    private static List<String> getPathList(AccountDTO account) {
        List<String> list = new LinkedList<String>();
        getPathListRec(account.getParent(), list);
        return list;
    }

    private static void getPathListRec(AccountDTO account, List<String> list) {
        if (account.getParent() == null) {
            // end
        } else {
            list.add(account.getIdNumber());
            getPathListRec(account.getParent(), list);
        }
    }

    public static EntryDTO mapToEntryDTO(GenericValueGlEntryAndGlEntryAccount value, List<AccountDTO> accounts) {
        return new EntryDTO(
                String.valueOf(value.getSequenceId()),
                value.getDescription(),
                DTOHelper.format(value.getAmount()),
                value.getDebitCreditEnumId().equals("DEBIT"),
                null,
                ServiceHelper.findAccountById(accounts, value.getAccountAccount()),
                null,
                null);
    }
}
