/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.lima.service.neogia;

import org.chorem.lima.service.JournalService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.JournalDTO;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.ofbiz.webservice.proxies.AddJournalDocument;
import org.ofbiz.webservice.proxies.AddJournalDocument.AddJournal;
import org.ofbiz.webservice.proxies.GetAllJournalResponseDocument;
import org.ofbiz.webservice.proxies.RemoveJournalDocument;
import org.ofbiz.webservice.proxies.RemoveJournalDocument.RemoveJournal;
import org.ofbiz.webservice.proxies.UpdateJournalDocument;
import org.ofbiz.webservice.proxies.UpdateJournalDocument.UpdateJournal;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionType;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.chorem.lima.service.util.ServiceHelper;

/** @author ore */
public class NeogiaJournalService implements JournalService {

    /** log */
    protected static final Log log = LogFactory.getLog(NeogiaJournalService.class);

    @Override
    public String addJournal(JournalDTO journal) {
        try {
            AddJournalStub stub = new AddJournalStub();
            AddJournalDocument document = AddJournalDocument.Factory.newInstance();
            AddJournal element = AddJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            element.setDescription(journal.getDescription());
            element.setPrefix(journal.getPrefix());
            document.setAddJournal(element);

            stub.addJournal(document);

            if (log.isDebugEnabled()) {
                log.debug("journal " + journal.getIdName() + " added");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't add a journal.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String updateJournal(JournalDTO journal) {
        try {
            UpdateJournalStub stub = new UpdateJournalStub();
            UpdateJournalDocument document = UpdateJournalDocument.Factory.newInstance();
            UpdateJournal element = UpdateJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            element.setDescription(journal.getDescription());
            element.setPrefix(journal.getPrefix());
            document.setUpdateJournal(element);

            stub.updateJournal(document);

            if (log.isDebugEnabled()) {
                log.debug("journal " + journal.getIdName() + " updated");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't update a journal.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String removeJournal(JournalDTO journal) {
        try {
            RemoveJournalStub stub = new RemoveJournalStub();
            RemoveJournalDocument document = RemoveJournalDocument.Factory.newInstance();
            RemoveJournal element = RemoveJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            document.setRemoveJournal(element);

            stub.removeJournal(document);

            if (log.isDebugEnabled()) {
                log.debug("journal " + journal.getIdName() + " removed ");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't remove a journal.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public List<JournalDTO> getAllJournal() {
        List<JournalDTO> list = new LinkedList<JournalDTO>();
        try {
            GetAllJournalStub stub = new GetAllJournalStub();
            GetAllJournalResponseDocument response = stub.getAllJournal();
            GenericValueAcctgTransactionType[] array = response.getGetAllJournalResponse().getReturnArray();

            for (GenericValueAcctgTransactionType value : array) {
                JournalDTO journal = NeogiaUtil.mapToJournalDTO(value);
                list.add(journal);
            }
        } catch (RemoteException ex) {
            log.fatal("Can't get all journals.", ex);
        }
        return list;
    }
}
