package org.chorem.lima.server;

/*
 * #%L
 * Lima :: Server
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */


import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaBusinessConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.report.LimaReportConfig;
import org.nuiton.config.ApplicationConfig;

import javax.naming.Context;
import javax.naming.NamingException;
import java.util.Properties;

/**
 * Lima server class.
 * <p/>
 * Starts openejb server.
 *
 * @author chatellier
 * @version $Revision$
 *          <p/>
 *          Last update : $Date$
 *          By : $Author$
 */
public class LimaServer {

    private static final Log log = LogFactory.getLog(LimaServer.class);

    /** http serveur */
    protected static HttpServerService httpServerService;

    /**
     * Lima server.
     *
     * @param args
     * @throws NamingException
     */
    public static void main(String... args) throws NamingException {

        String accountabilityName = null;
        if (args!= null && args.length > 0 && StringUtils.isNotBlank(args[0])) {
            accountabilityName = args[0];
        }

        LimaServerConfig serverConfig = LimaServerConfig.getInstance(accountabilityName);

        Properties properties = serverConfig.getFlatOptions();
        properties.put("openejb.embedded.remotable",  "true");

        launch(serverConfig.getConfig());

        LimaServerConfig.getInstance().getConfig().saveForUser();

        // block main otherwize, main will end
        synchronized (properties) {
            try {
                properties.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        if (log.isInfoEnabled()) {
            log.info("LimaServer shutdown");
        }
    }

    public static void launch(ApplicationConfig moduleConfig) {

        boolean mustStartServer = StringUtils.isBlank(moduleConfig.getOption(Context.PROVIDER_URL)) ||
                moduleConfig.getOptionAsBoolean("openejb.embedded.remotable");

        ApplicationConfig initConfig = moduleConfig;

        if (mustStartServer) {
            // push all configs
            initConfig = LimaServerConfig.getInstance(initConfig).getConfig();
            initConfig = LimaBusinessConfig.getInstance(initConfig).getConfig();
            initConfig = LimaReportConfig.getInstance(initConfig).getConfig();
        }

        // start EJB container (either local or remote)
        LimaServiceFactory.initFactory(initConfig);

        // start web server only if it's on server mode
        if (mustStartServer) {
            httpServerService = new HttpServerService();
            httpServerService.start();
        }
    }

    public static HttpServerService getHttpServerService() {
        return httpServerService;
    }

}
