/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Transaction}.
 */
public abstract class TransactionAbstract extends TopiaEntityAbstract implements Transaction {

    private Date transDate;

    private String voucherRef;

    private String description;

    public TimeSpan timeSpan;

    public Journal journal;

    public Collection<Entry> entry;

    /**
     * Constructeur de TransactionAbstract par défaut.
     */
    public TransactionAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Transaction.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Transaction.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "transDate", Date.class, transDate);
        visitor.visit(this, "voucherRef", String.class, voucherRef);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "timeSpan", TimeSpan.class, timeSpan);
        visitor.visit(this, "journal", Journal.class, journal);
        visitor.visit(this, "entry", Collection.class, Entry.class, entry);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getEntry() != null) {
              tmp.addAll(getEntry());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#setTransDate(Date)
     */
    @Override
    public void setTransDate(Date value) {
        Date _oldValue = this.transDate;
        fireOnPreWrite("transDate", _oldValue, value);
        this.transDate = value;
        fireOnPostWrite("transDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Transaction#getTransDate()
     */
    @Override
    public Date getTransDate() {
        fireOnPreRead("transDate", transDate);
        Date result = this.transDate;
        fireOnPostRead("transDate", transDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#setVoucherRef(String)
     */
    @Override
    public void setVoucherRef(String value) {
        String _oldValue = this.voucherRef;
        fireOnPreWrite("voucherRef", _oldValue, value);
        this.voucherRef = value;
        fireOnPostWrite("voucherRef", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Transaction#getVoucherRef()
     */
    @Override
    public String getVoucherRef() {
        fireOnPreRead("voucherRef", voucherRef);
        String result = this.voucherRef;
        fireOnPostRead("voucherRef", voucherRef);
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#setDescription(String)
     */
    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Transaction#getDescription()
     */
    @Override
    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#setTimeSpan(TimeSpan)
     */
    @Override
    public void setTimeSpan(TimeSpan value) {
        TimeSpan _oldValue = this.timeSpan;
        fireOnPreWrite("timeSpan", _oldValue, value);
        this.timeSpan = value;
        fireOnPostWrite("timeSpan", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Transaction#getTimeSpan()
     */
    @Override
    public TimeSpan getTimeSpan() {
        fireOnPreRead("timeSpan", timeSpan);
        TimeSpan result = this.timeSpan;
        fireOnPostRead("timeSpan", timeSpan);
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#setJournal(Journal)
     */
    @Override
    public void setJournal(Journal value) {
        Journal _oldValue = this.journal;
        fireOnPreWrite("journal", _oldValue, value);
        this.journal = value;
        fireOnPostWrite("journal", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Transaction#getJournal()
     */
    @Override
    public Journal getJournal() {
        fireOnPreRead("journal", journal);
        Journal result = this.journal;
        fireOnPostRead("journal", journal);
        return result;
    }

    /* (non-Javadoc)
     * @see Transaction#addEntry(Entry)
     */
    @Override
    public void addEntry(Entry entry) {
        fireOnPreWrite("entry", null, entry);
        if (this.entry == null) {
            this.entry = new ArrayList<Entry>();
        }
        entry.setTransaction(this);
        this.entry.add(entry);
        fireOnPostWrite("entry", this.entry.size(), null, entry);
    }

    /* (non-Javadoc)
     * @see Transaction#addAllEntry(Collection<Entry>)
     */
    @Override
    public void addAllEntry(Collection<Entry> values) {
        if (values == null) {
            return;
        }
        for (Entry item : values) {
            addEntry(item);
        }
    }

    /* (non-Javadoc)
     * @see Transaction#getEntryByTopiaId(String)
     */
    @Override
    public Entry getEntryByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(entry, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Transaction#setEntry(Collection<Entry>)
     */
    @Override
    public void setEntry(Collection<Entry> values) {
        Collection<Entry> _oldValue = entry;
        fireOnPreWrite("entry", _oldValue, values);
        entry = values;
        fireOnPostWrite("entry", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Transaction#removeEntry(Entry)
     */
    @Override
    public void removeEntry(Entry value) {
        fireOnPreWrite("entry", value, null);
        if ((this.entry == null) || (!this.entry.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setTransaction(null);
        fireOnPostWrite("entry", this.entry.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Transaction#clearEntry()
     */
    @Override
    public void clearEntry() {
        if (this.entry == null) {
            return;
        }
        for (Entry item : this.entry) {
            item.setTransaction(null);
        }
        Collection<Entry> _oldValue = new ArrayList<Entry>(this.entry);
        fireOnPreWrite("entry", _oldValue, this.entry);
        this.entry.clear();
        fireOnPostWrite("entry", _oldValue, this.entry);
    }

    /* (non-Javadoc)
     * @see Transaction#getEntry()
     */
    @Override
    public Collection<Entry> getEntry() {
        return entry;
    }

    /* (non-Javadoc)
     * @see Transaction#sizeEntry()
     */
    @Override
    public int sizeEntry() {
        if (entry == null) {
            return 0;
        }
        return entry.size();
    }

    /* (non-Javadoc)
     * @see Transaction#isEntryEmpty()
     */
    @Override
    public boolean isEntryEmpty() {
        int size = sizeEntry();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("transDate", this.transDate).
            append("voucherRef", this.voucherRef).
            append("description", this.description).
         toString();
        return result;
    }
        
} //TransactionAbstract
