/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigElement {
    private String m_name;
    private String m_value;
    private Map<String, String> m_attributes;
    private List<ConfigElement> m_children;

    public ConfigElement(String name, String value) {
        this.m_name = name;
        this.m_value = value;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAttribute(String name) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public boolean hasAttribute(String name) {
        if (this.m_attributes != null) {
            return this.m_attributes.containsKey(name);
        }
        return false;
    }

    public int getAttributeCount() {
        if (this.m_attributes != null) {
            return this.m_attributes.size();
        }
        return 0;
    }

    public String getValue() {
        return this.m_value;
    }

    public ConfigElement getChild(String name) {
        if (this.m_children != null) {
            for (ConfigElement child : this.m_children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public List<ConfigElement> getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        if (this.m_children == null) {
            return false;
        }
        return this.m_children.size() > 0;
    }

    public int getChildCount() {
        if (this.m_children != null) {
            return this.m_children.size();
        }
        return 0;
    }

    public ConfigElement combine(ConfigElement configElement) {
        return null;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void addAttribute(String attrName, String attrVal) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap<String, String>();
        }
        this.m_attributes.put(attrName, attrVal);
    }

    public void addChild(ConfigElement child) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<ConfigElement>();
        }
        this.m_children.add(child);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append("=");
        str.append(this.getValue());
        str.append(",Attrs=");
        str.append(this.getAttributeCount());
        str.append(",Children=");
        str.append(this.getChildCount());
        str.append("]");
        return str.toString();
    }
}

