/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio.win32;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCIFSRequestHandler;
import org.alfresco.jlan.smb.server.win32.WinsockNetBIOSPacketHandler;

public class AsyncWinsockCIFSReadRequest
implements ThreadRequest {
    private SMBSrvSession m_sess;
    private int m_socketEvent;
    private AsyncWinsockCIFSRequestHandler m_reqHandler;

    public AsyncWinsockCIFSReadRequest(SMBSrvSession sess, int sockEvent, AsyncWinsockCIFSRequestHandler reqHandler) {
        this.m_sess = sess;
        this.m_socketEvent = sockEvent;
        this.m_reqHandler = reqHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            SMBSrvPacket smbPkt = null;
            try {
                WinsockNetBIOSPacketHandler pktHandler = (WinsockNetBIOSPacketHandler)this.m_sess.getPacketHandler();
                smbPkt = pktHandler.readPacket();
                this.m_sess.setReadInProgress(false);
                if (smbPkt == null) {
                    this.m_sess.hangupSession("Client closed socket");
                }
                this.m_sess.processPacket(smbPkt);
                smbPkt = null;
            }
            catch (Throwable ex) {
                Debug.println(ex);
            }
            finally {
                if (smbPkt != null) {
                    this.m_sess.getPacketPool().releasePacket(smbPkt);
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Async Winsock CIFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("-Read]");
        return str.toString();
    }
}

