/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.memory;

import org.alfresco.jlan.server.memory.ByteBufferList;

public class ByteBufferPool {
    private ByteBufferList[] m_bufferLists;
    private int[] m_bufSizes;
    private int[] m_initAlloc;
    private int[] m_maxAlloc;

    public ByteBufferPool(int[] bufSizes, int[] initAlloc, int[] maxAlloc) {
        if (bufSizes.length != initAlloc.length && bufSizes.length != maxAlloc.length) {
            throw new RuntimeException("Invalid ByteBufferPool parameters");
        }
        this.m_bufSizes = bufSizes;
        this.m_initAlloc = initAlloc;
        this.m_maxAlloc = maxAlloc;
        this.m_bufferLists = new ByteBufferList[this.m_bufSizes.length];
        for (int i = 0; i < this.m_bufSizes.length; ++i) {
            ByteBufferList bufList;
            this.m_bufferLists[i] = bufList = new ByteBufferList(this.m_bufSizes[i], this.m_initAlloc[i], this.m_maxAlloc[i]);
        }
    }

    public final byte[] allocateBuffer(int siz) {
        return this.allocateBuffer(siz, 0L);
    }

    public final byte[] allocateBuffer(int siz, long waitTime) {
        int idx;
        for (idx = 0; idx < this.m_bufSizes.length && siz > this.m_bufSizes[idx]; ++idx) {
        }
        if (idx == this.m_bufSizes.length) {
            throw new RuntimeException("Requested allocation size too long for pool, " + siz);
        }
        return this.m_bufferLists[idx].allocateBuffer(waitTime);
    }

    public final void releaseBuffer(byte[] buf) {
        int idx;
        for (idx = 0; idx < this.m_bufSizes.length && buf.length != this.m_bufSizes[idx]; ++idx) {
        }
        if (idx == this.m_bufSizes.length) {
            throw new RuntimeException("Released buffer does not match any buffer sizes, " + buf.length);
        }
        this.m_bufferLists[idx].releaseBuffer(buf);
    }

    public final void shrinkLists() {
        for (int i = 0; i < this.m_bufferLists.length; ++i) {
            this.m_bufferLists[i].shrinkList();
        }
    }

    public final int getSmallestSize() {
        return this.m_bufSizes[0];
    }

    public final int getLargestSize() {
        return this.m_bufSizes[this.m_bufSizes.length - 1];
    }

    public final ByteBufferList[] getBufferList() {
        return this.m_bufferLists;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[BufferLists: ");
        for (int i = 0; i < this.m_bufferLists.length; ++i) {
            str.append(this.m_bufferLists[i].toString());
            str.append(" ");
        }
        str.append("]");
        return str.toString();
    }
}

