/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

import java.util.Enumeration;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.springframework.extensions.config.ConfigElement;

public class DefaultShareMapper
implements ShareMapper,
ConfigurationListener {
    private ServerConfiguration m_config;
    private FilesystemsConfigSection m_filesysConfig;
    private boolean m_debug;

    @Override
    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        if (this.m_filesysConfig == null) {
            this.m_config.addListener(this);
        }
        if (params.getChild("debug") != null) {
            this.m_debug = true;
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public SharedDevice findShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDevice share = null;
        share = this.m_filesysConfig.getShares().findShare(name, typ, false);
        if (share == null) {
            share = this.m_filesysConfig.getShares().findShare(name, typ, true);
        }
        if (share != null && share.getContext() != null && !share.getContext().isAvailable()) {
            share = null;
        }
        return share;
    }

    @Override
    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = enm.nextElement();
            shr.getContext().CloseContext();
            if (!this.hasDebug()) continue;
            Debug.println("Deleted dynamic share " + shr);
        }
    }

    @Override
    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (this.m_filesysConfig == null) {
            return null;
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    @Override
    public void closeMapper() {
    }

    @Override
    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        if (id == 0x10000001) {
            if (newVal instanceof FilesystemsConfigSection) {
                this.m_filesysConfig = (FilesystemsConfigSection)newVal;
            }
            return 1;
        }
        return 0;
    }
}

