/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.config;

import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.memory.ByteBufferPool;
import org.alfresco.jlan.server.thread.ThreadRequestPool;

public class CoreServerConfigSection
extends ConfigSection {
    public static final String SectionName = "CoreServer";
    private ThreadRequestPool m_threadPool;
    private ByteBufferPool m_memoryPool;

    public CoreServerConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final ThreadRequestPool getThreadPool() {
        return this.m_threadPool;
    }

    public final ByteBufferPool getMemoryPool() {
        return this.m_memoryPool;
    }

    public final void setThreadPool(int initSize, int maxSize) throws InvalidConfigurationException {
        if (initSize <= 0 || maxSize <= 0) {
            throw new InvalidConfigurationException("Invalid initial or maximum thread count, " + initSize + "/" + maxSize);
        }
        if (initSize > maxSize) {
            throw new InvalidConfigurationException("Invalid initial thread count, higher than maximum count, " + initSize + "/" + maxSize);
        }
        if (this.m_threadPool != null) {
            throw new InvalidConfigurationException("Thread pool already configured");
        }
        this.m_threadPool = new ThreadRequestPool("AlfJLANWorker", initSize);
    }

    public final void setMemoryPool(int[] pktSizes, int[] initAlloc, int[] maxAlloc) throws InvalidConfigurationException {
        if (pktSizes.length != initAlloc.length || pktSizes.length != maxAlloc.length) {
            throw new InvalidConfigurationException("Invalid packet size/allocation lists, lengths do not match");
        }
        if (pktSizes.length > 1) {
            for (int i = 1; i <= pktSizes.length - 1; ++i) {
                if (pktSizes[i] >= pktSizes[i - 1]) continue;
                throw new InvalidConfigurationException("Packet size list is not in ascending order");
            }
        }
        if (this.m_memoryPool != null) {
            throw new InvalidConfigurationException("Memory pool already configured");
        }
        this.m_memoryPool = new ByteBufferPool(pktSizes, initAlloc, maxAlloc);
    }
}

