/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.SMBPacket;
import org.alfresco.jlan.server.auth.passthru.TcpipSMBNetworkSession;
import org.alfresco.jlan.smb.Dialect;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.IPAddress;

public final class AuthSessionFactory {
    private static final int BROADCAST_LOOKUP_TIMEOUT = 4000;
    private static DialectSelector m_defDialects;
    private static int m_sessIdx;
    private static String m_localDomain;
    private static String m_localBrowseMaster;
    private static int m_defPktSize;
    private static InetAddress[] m_localAddrList;
    private static PasswordEncryptor m_encryptor;
    private static int m_evalCount;
    private static String m_defUserName;
    private static String m_defPassword;
    private static String m_defDomain;
    private static int m_primaryProto;
    private static int m_secondaryProto;
    private static boolean m_debug;
    private static int m_netbiosPort;
    private static String m_netBIOSScopeId;

    private static final Vector BuildNegotiatePacket(SMBPacket pkt, DialectSelector dlct, int pid) {
        pkt.setCommand(114);
        pkt.setProcessId(pid);
        if (dlct.hasDialect(7)) {
            pkt.setFlags2(32768);
        }
        StringBuffer dia = new StringBuffer();
        Vector<String> vec = new Vector<String>();
        for (int d = 0; d < 8; ++d) {
            if (!dlct.hasDialect(d)) continue;
            for (int i = 0; i < Dialect.NumberOfDialects(); ++i) {
                if (Dialect.DialectType(i) != d) continue;
                String curDialect = Dialect.DialectString(i);
                vec.addElement(curDialect);
                dia.append('\u0002');
                dia.append(curDialect);
                dia.append('\u0000');
            }
        }
        pkt.setBytes(dia.toString().getBytes());
        return vec;
    }

    private static void CheckLicence() throws SMBException {
        if (m_evalCount >= 0) {
            if (m_evalCount == 0) {
                throw new SMBException(5, 4);
            }
            --m_evalCount;
        }
        if (m_evalCount != -1 && System.currentTimeMillis() > 1122678055578L) {
            throw new SMBException(5, 2);
        }
    }

    protected static final int DefaultPacketSize() {
        return m_defPktSize;
    }

    public static final void disableDebug() {
        m_debug = false;
    }

    public static final void enableDebug() {
        m_debug = true;
    }

    public static final DialectSelector getDefaultDialects() {
        return m_defDialects;
    }

    public static String getDefaultDomain() {
        return m_defDomain;
    }

    public static String getDefaultPassword() {
        return m_defPassword;
    }

    public static String getDefaultUserName() {
        return m_defUserName;
    }

    public static String getNetBIOSNameScope() {
        return m_netBIOSScopeId;
    }

    public static int getNetBIOSPort() {
        return m_netbiosPort;
    }

    public static final int getPrimaryProtocol() {
        return m_primaryProto;
    }

    public static final int getSecondaryProtocol() {
        return m_secondaryProto;
    }

    private static synchronized int getSessionId() {
        int sessId = m_sessIdx++ + NetBIOSSession.getJVMIndex() * 100;
        return sessId;
    }

    private static synchronized InetAddress[] getLocalTcpipAddresses() {
        if (m_localAddrList == null) {
            try {
                m_localAddrList = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return m_localAddrList;
    }

    public static final boolean hasDebug() {
        return m_debug;
    }

    public static final boolean hasNetBIOSNameScope() {
        return m_netBIOSScopeId != null;
    }

    public static final boolean hasSessionDebug() {
        return AuthenticateSession.hasDebug();
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr, int tmo) throws IOException, UnknownHostException, SMBException {
        return AuthSessionFactory.OpenAuthenticateSession(shr, tmo, null);
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr, int tmo, DialectSelector dia) throws IOException, UnknownHostException, SMBException {
        int pid = AuthSessionFactory.getSessionId();
        StringBuffer nameBuf = new StringBuffer(InetAddress.getLocalHost().getHostName() + "_" + pid);
        String localName = nameBuf.toString();
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** New auth session from " + localName + " to " + shr.toString());
            Debug.println("** os.arch = " + System.getProperty("os.arch") + ", java.version: " + System.getProperty("java.version"));
        }
        NetworkSession netSession = null;
        switch (AuthSessionFactory.getPrimaryProtocol()) {
            case 1: {
                netSession = AuthSessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, tmo);
                break;
            }
            case 2: {
                netSession = AuthSessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, tmo);
            }
        }
        if (netSession == null) {
            switch (AuthSessionFactory.getSecondaryProtocol()) {
                case 1: {
                    netSession = AuthSessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, tmo);
                    break;
                }
                case 2: {
                    netSession = AuthSessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, tmo);
                }
            }
        }
        if (netSession == null) {
            throw new IOException("Failed to connect to host, " + shr.getNodeName());
        }
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** Connected session, protocol : " + netSession.getProtocolName());
        }
        SMBPacket pkt = new SMBPacket();
        DialectSelector selDialect = dia;
        if (selDialect == null) {
            selDialect = new DialectSelector();
            selDialect.copyFrom(m_defDialects);
        }
        Vector diaList = AuthSessionFactory.BuildNegotiatePacket(pkt, selDialect, pid);
        pkt.ExchangeLowLevelSMB(netSession, pkt, true);
        String diaStr = (String)diaList.elementAt(pkt.getParameter(0));
        int dialectId = Dialect.DialectType(diaStr);
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** SessionFactory: Negotiated SMB dialect " + diaStr);
        }
        if (dialectId == -1) {
            throw new IOException("Unknown SMB dialect");
        }
        AuthenticateSession authSess = new AuthenticateSession(shr, netSession, dialectId, pkt);
        return authSess;
    }

    public static void setDefaultDomain(String domain) {
        m_defDomain = domain;
    }

    public static void setDefaultPassword(String pwd) {
        m_defPassword = pwd;
    }

    public static void setDefaultUserName(String user) {
        m_defUserName = user;
    }

    public static void setNetBIOSPort(int port) {
        m_netbiosPort = port;
    }

    public static void setNetBIOSNameScope(String scope) {
        m_netBIOSScopeId = scope != null && scope.startsWith(".") ? scope.substring(1) : scope;
    }

    public static final boolean setProtocolOrder(int pri, int sec) {
        if (pri != 1 && pri != 2) {
            return false;
        }
        if (pri == sec) {
            return false;
        }
        m_primaryProto = pri;
        m_secondaryProto = sec;
        return true;
    }

    public static final void setSessionDebug(boolean dbg) {
        if (dbg) {
            AuthenticateSession.setDebug(1);
        } else {
            AuthenticateSession.setDebug(0);
        }
    }

    public static final void setSubnetMask(String subnet) {
        NetBIOSSession.setDefaultSubnetMask(subnet);
    }

    private static void SetupDefaultDialects() {
        if (m_defDialects == null) {
            m_defDialects = new DialectSelector();
        } else {
            m_defDialects.ClearAll();
        }
        m_defDialects.AddDialect(0);
        m_defDialects.AddDialect(1);
        m_defDialects.AddDialect(2);
        m_defDialects.AddDialect(4);
        m_defDialects.AddDialect(3);
        m_defDialects.AddDialect(5);
        m_defDialects.AddDialect(6);
        m_defDialects.AddDialect(7);
    }

    private static final NetworkSession connectNetBIOSSession(String toName, String fromName, int tmo) throws IOException {
        String ipAddr;
        InetAddress[] addrList;
        int addrIdx;
        NetBIOSSession nbSession = new NetBIOSSession(tmo, AuthSessionFactory.getNetBIOSPort(), 137);
        String toAddr = null;
        NetBIOSName nbName = null;
        if (IPAddress.isNumericAddress(toName)) {
            try {
                toAddr = toName;
                NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(toAddr);
                nbName = nameList.findName(' ', false);
                if (nbName == null) {
                    throw new IOException("Server service not running");
                }
                toName = nbName.getName();
            }
            catch (UnknownHostException ex) {
                return null;
            }
        } else {
            nbName = NetBIOSSession.FindName(toName, ' ', 500);
        }
        if (AuthSessionFactory.hasNetBIOSNameScope()) {
            toName = toName + "." + AuthSessionFactory.getNetBIOSNameScope();
            fromName = fromName + "." + AuthSessionFactory.getNetBIOSNameScope();
        }
        if (nbName.numberOfAddresses() > 1 && (addrIdx = nbName.findBestMatchAddress(addrList = AuthSessionFactory.getLocalTcpipAddresses())) != -1) {
            try {
                ipAddr = nbName.getIPAddressString(addrIdx);
                if (AuthSessionFactory.hasSessionDebug()) {
                    Debug.println("** Server is multi-homed, trying to connect to " + ipAddr);
                }
                nbSession.Open(toName, fromName, ipAddr);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception ex) {}
                } else if (AuthSessionFactory.hasSessionDebug() && nbSession.isConnected()) {
                    Debug.println("** Connected to address " + ipAddr);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (AuthSessionFactory.hasSessionDebug() && !nbSession.isConnected() && nbName.numberOfAddresses() > 1) {
            Debug.println("** Server is multi-homed, trying all addresses");
        }
        IOException lastException = null;
        addrIdx = 0;
        while (!nbSession.isConnected() && addrIdx < nbName.numberOfAddresses()) {
            try {
                ipAddr = nbName.getIPAddressString(addrIdx++);
                if (AuthSessionFactory.hasSessionDebug()) {
                    Debug.println("** Trying address " + ipAddr);
                }
                nbSession.Open(toName, fromName, ipAddr);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (!AuthSessionFactory.hasSessionDebug() || !nbSession.isConnected()) continue;
                Debug.println("** Connected to address " + ipAddr);
            }
            catch (IOException ex) {
                lastException = ex;
            }
        }
        if (!nbSession.isConnected()) {
            if (lastException != null) {
                throw lastException;
            }
            return null;
        }
        return nbSession;
    }

    private static final NetworkSession connectNativeSMBSession(String toName, String fromName, int tmo) throws IOException {
        TcpipSMBNetworkSession tcpSession;
        block6: {
            tcpSession = new TcpipSMBNetworkSession(tmo);
            try {
                tcpSession.Open(toName, fromName, null);
                if (tcpSession.isConnected()) break block6;
                try {
                    tcpSession.Close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception ex) {
                try {
                    tcpSession.Close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                tcpSession = null;
            }
        }
        return tcpSession;
    }

    static {
        m_sessIdx = 1;
        m_localDomain = null;
        m_localBrowseMaster = null;
        m_defPktSize = 4100;
        m_encryptor = new PasswordEncryptor();
        m_evalCount = -1;
        m_defDialects = new DialectSelector();
        m_defDialects.AddDialect(0);
        m_defDialects.AddDialect(1);
        m_defDialects.AddDialect(2);
        m_defDialects.AddDialect(4);
        m_defDialects.AddDialect(3);
        m_defDialects.AddDialect(5);
        m_defDialects.AddDialect(6);
        m_defDialects.AddDialect(7);
        m_defUserName = "";
        m_defPassword = "";
        m_defDomain = "?";
        m_primaryProto = 1;
        m_secondaryProto = 2;
        m_debug = false;
        m_netbiosPort = 139;
        m_netBIOSScopeId = null;
    }
}

