/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import java.io.IOException;
import java.util.Iterator;
import org.alfresco.jlan.server.auth.asn.DERApplicationSpecific;
import org.alfresco.jlan.server.auth.asn.DERBitString;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERInteger;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DERSequence;

public class KerberosApReq {
    public static final int APOptionUseSessionKey = 1;
    public static final int APOptionMutualAuthReq = 2;
    private static final int APOptionUseSessionKeyMask = 0x40000000;
    private static final int APOptionsMutualAuthReqMask = 0x20000000;
    private int m_APOptions;
    private byte[] m_ticket;
    private int m_authEncType;
    private byte[] m_authEncData;
    private int m_authEncKvno = -1;

    public KerberosApReq() {
    }

    public KerberosApReq(byte[] blob) throws IOException {
        this.parseApReq(blob);
    }

    public final int getAPOptions() {
        return this.m_APOptions;
    }

    public final boolean useSessionKey() {
        return (this.m_APOptions & 0x40000000) != 0;
    }

    public final boolean hasMutualAuthentication() {
        return (this.m_APOptions & 0x20000000) != 0;
    }

    public final byte[] getTicket() {
        return this.m_ticket;
    }

    public final int getAuthenticatorEncType() {
        return this.m_authEncType;
    }

    public final byte[] getAuthenticator() {
        return this.m_authEncData;
    }

    public final int getAuthenticatorKeyVersion() {
        return this.m_authEncKvno;
    }

    private final void parseApReq(byte[] blob) throws IOException {
        DERBuffer derBuf = new DERBuffer(blob);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            Iterator<DERObject> iterObj = derSeq.getObjects();
            block12: while (iterObj.hasNext()) {
                derObj = iterObj.next();
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        if (derInt.getValue() == 5L) continue block12;
                        throw new IOException("Unexpected PVNO value in AP-REQ");
                    }
                    case 1: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        if (derInt.getValue() == 14L) continue block12;
                        throw new IOException("Unexpected msg-type value in AP-REQ");
                    }
                    case 2: {
                        if (!(derObj instanceof DERBitString)) break;
                        DERBitString derBit = (DERBitString)derObj;
                        this.m_APOptions = derBit.intValue();
                        break;
                    }
                    case 3: {
                        if (!(derObj instanceof DERApplicationSpecific)) break;
                        DERApplicationSpecific derApp = (DERApplicationSpecific)derObj;
                        this.m_ticket = derApp.getValue();
                        break;
                    }
                    case 4: {
                        if (!(derObj instanceof DERSequence)) break;
                        DERSequence derAuthSeq = (DERSequence)derObj;
                        Iterator<DERObject> iterSeq = derAuthSeq.getObjects();
                        while (iterSeq.hasNext()) {
                            derObj = iterSeq.next();
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) break;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_authEncType = derInt.intValue();
                                    break;
                                }
                                case 1: {
                                    if (!(derObj instanceof DERInteger)) break;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_authEncKvno = derInt.intValue();
                                    break;
                                }
                                case 2: {
                                    if (!(derObj instanceof DEROctetString)) break;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_authEncData = derOct.getValue();
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public final void parseMechToken(byte[] mechToken) throws IOException {
        DERBuffer derBuf = new DERBuffer(mechToken);
        byte[] apreqBlob = null;
        byte[] appByts = derBuf.unpackApplicationSpecificBytes();
        if (appByts != null) {
            derBuf = new DERBuffer(appByts);
            DERObject derObj = derBuf.unpackObject();
            derBuf.unpackByte();
            derBuf.unpackByte();
            apreqBlob = derBuf.unpackApplicationSpecificBytes();
        }
        if (apreqBlob == null) {
            throw new IOException("AP-REQ blob not found in mechToken");
        }
        this.parseApReq(apreqBlob);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[AP-REQ:APOptions=");
        str.append(this.hasMutualAuthentication() ? "MutualAuth " : "");
        str.append(this.useSessionKey() ? "UseSessKey" : "");
        str.append(",Ticket=Len=");
        str.append(this.m_ticket != null ? this.m_ticket.length : 0);
        str.append(",Authenticator=EncType=");
        str.append(this.m_authEncType);
        str.append(",Kvno=");
        str.append(this.getAuthenticatorKeyVersion());
        str.append(",Len=");
        str.append(this.m_authEncData != null ? this.m_authEncData.length : 0);
        str.append("]");
        return str.toString();
    }
}

