/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server;

import java.util.Vector;
import org.alfresco.jlan.server.SessionHandlerInterface;

public class SessionHandlerList {
    private Vector<SessionHandlerInterface> m_handlers = new Vector();

    public final void addHandler(SessionHandlerInterface handler) {
        this.m_handlers.add(handler);
    }

    public final int numberOfHandlers() {
        return this.m_handlers.size();
    }

    public final SessionHandlerInterface getHandlerAt(int idx) {
        if (idx < 0 || idx >= this.m_handlers.size()) {
            return null;
        }
        return this.m_handlers.get(idx);
    }

    public final SessionHandlerInterface findHandler(String name) {
        for (int i = 0; i < this.m_handlers.size(); ++i) {
            SessionHandlerInterface handler = this.m_handlers.get(i);
            if (!handler.getHandlerName().equals(name)) continue;
            return handler;
        }
        return null;
    }

    public final SessionHandlerInterface remoteHandler(int idx) {
        if (idx < 0 || idx >= this.m_handlers.size()) {
            return null;
        }
        return this.m_handlers.remove(idx);
    }

    public final SessionHandlerInterface remoteHandler(String name) {
        for (int i = 0; i < this.m_handlers.size(); ++i) {
            SessionHandlerInterface handler = this.m_handlers.get(i);
            if (!handler.getHandlerName().equals(name)) continue;
            this.m_handlers.removeElementAt(i);
            return handler;
        }
        return null;
    }

    public final void removeAllHandlers() {
        this.m_handlers.removeAllElements();
    }

    public final synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.m_handlers.size() == 0) {
            this.wait();
        }
    }
}

