/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.TransactBuffer;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

public class TransPacket
extends SMBPacket {
    protected static final int StandardParams = 14;
    protected static final int RxStandardParams = 10;
    protected static final int SetupOffset = 67;
    protected String m_transName;
    protected int m_paramCnt;

    public TransPacket(byte[] buf) {
        super(buf);
    }

    public TransPacket(int siz) {
        super(siz);
    }

    public final int getDataLength() {
        return this.getParameter(6);
    }

    public final int getDataOffset() {
        return this.getParameter(7) + 4;
    }

    public final void getParameterBlock(short[] prmblk) throws ArrayIndexOutOfBoundsException {
        int prmcnt = this.getParameter(3) / 2;
        if (prmblk.length < prmcnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int pos = this.getParameter(4) + 4;
        byte[] buf = this.getBuffer();
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = (short)DataPacker.getIntelShort(buf, pos);
            pos += 2;
        }
        if (Session.hasDebugOption(2)) {
            Debug.println("Transaction parameter dump - " + prmcnt + " params :-");
            for (int i = 0; i < prmcnt; ++i) {
                Debug.println(" " + i + ". = " + prmblk[i] + ", 0x" + Integer.toHexString(prmblk[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransactBuffer doTransaction(Session sess, TransactBuffer tbuf) throws IOException, SMBException {
        int dlen;
        int plen;
        int mid = sess.getNextMultiplexId();
        if (tbuf.hasName()) {
            this.setCommand(37);
        } else {
            this.setCommand(50);
        }
        this.setFlags(sess.getDefaultFlags());
        this.setFlags2(sess.getDefaultFlags2());
        this.setMultiplexId(mid);
        this.setTreeId(sess.getTreeId());
        this.setUserId(sess.getUserId());
        tbuf.setEndOfBuffer();
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        if (tbuf.hasSetupBuffer()) {
            this.setParameterCount(14 + setupBuf.getLengthInWords() + 1);
        } else {
            this.setParameterCount(15);
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            this.setParameter(i, 0);
        }
        int totParamLen = paramBuf != null ? paramBuf.getLength() : 0;
        int totDataLen = dataBuf != null ? dataBuf.getLength() : 0;
        this.setTotalParameterCount(totParamLen);
        this.setTotalDataCount(totDataLen);
        this.setMaximumParameterReturn(tbuf.getReturnParameterLimit());
        this.setMaximumDataReturn(tbuf.getReturnDataLimit());
        int availBuf = this.getAvailableLength();
        int pos = this.getByteOffset();
        if (tbuf.hasName()) {
            pos = DataPacker.putString(tbuf.getName(), this.getBuffer(), pos, false);
            availBuf -= tbuf.getName().length();
        }
        if ((plen = totParamLen) + (dlen = totDataLen) > availBuf) {
            if (plen > 0) {
                if (plen <= availBuf) {
                    if (dlen > 0) {
                        dlen = availBuf - plen;
                    }
                } else {
                    dlen = plen = availBuf / 2;
                }
            } else if (dlen > availBuf) {
                dlen = availBuf;
            }
        }
        this.setParameterBlockCount(plen);
        this.setParameterBlockOffset(0);
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(0);
        this.setSetupCount(setupBuf != null ? setupBuf.getLengthInWords() : 1);
        this.setSetupParameter(0, tbuf.getFunction());
        if (setupBuf != null) {
            setupBuf.copyData(this.getBuffer(), 67);
        }
        pos = DataPacker.wordAlign(pos);
        this.setPosition(pos);
        this.setParameterBlockOffset(pos);
        int packLen = -1;
        if (paramBuf != null) {
            packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
            pos = DataPacker.wordAlign(pos + packLen);
            this.setPosition(pos);
        }
        this.setDataBlockOffset(pos);
        if (dataBuf != null) {
            packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
            this.setPosition(pos + packLen);
        }
        this.setByteCount();
        TransactBuffer respBuf = null;
        try {
            sess.setTransactionMID(mid);
            this.SendSMB(sess);
            if (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
                this.ReceiveSMB(sess);
            }
            availBuf = this.getAvailableLength();
            while (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
                this.setCommand(tbuf.isType() == 37 ? 38 : 51);
                this.setFlags(sess.getDefaultFlags());
                this.setFlags2(sess.getDefaultFlags2());
                this.setParameterCount(8);
                this.setTotalParameterCount(totParamLen);
                this.setTotalDataCount(totDataLen);
                this.setMultiplexId(sess.getNextMultiplexId());
                plen = paramBuf != null ? paramBuf.getAvailableLength() : 0;
                int n = dlen = dataBuf != null ? dataBuf.getAvailableLength() : 0;
                if (plen + dlen > availBuf) {
                    if (plen > 0) {
                        if (plen <= availBuf) {
                            if (dlen > 0) {
                                dlen = availBuf - plen;
                            }
                        } else {
                            dlen = plen = availBuf / 2;
                        }
                    } else if (dlen > availBuf) {
                        dlen = availBuf;
                    }
                }
                this.resetBytePointerAlign();
                packLen = -1;
                pos = this.getPosition();
                if (plen > 0 && paramBuf != null) {
                    this.setParameterBlockOffset(pos);
                    packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
                    pos = DataPacker.wordAlign(pos + packLen);
                    this.setPosition(pos);
                }
                if (dlen > 0 && dataBuf != null) {
                    this.setDataBlockOffset(pos);
                    packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
                    this.setPosition(pos + packLen);
                }
                this.setByteCount();
                this.SendSMB(sess);
            }
            this.setCommand(tbuf.hasName() ? 37 : 50);
            this.ReceiveSMB(sess, false);
            if (!this.isValidResponse()) {
                this.checkForError();
            }
            totParamLen = this.getTotalParameterCount();
            totDataLen = this.getTotalDataCount();
            int setupLen = (this.getParameterCount() - 10) * 2;
            respBuf = new TransactBuffer(setupLen, totParamLen, totDataLen);
            respBuf.setUnicode(this.isUnicode());
            setupBuf = respBuf.getSetupBuffer();
            paramBuf = respBuf.getParameterBuffer();
            dataBuf = respBuf.getDataBuffer();
            if (setupLen > 0) {
                setupBuf.appendData(this.getBuffer(), 67, setupLen);
            }
            if (Session.hasDebug()) {
                Debug.println("Receive transaction totParamLen=" + totParamLen + ", totDataLen=" + totDataLen);
            }
            while (paramBuf != null && paramBuf.getUsedLength() < totParamLen || dataBuf != null && dataBuf.getUsedLength() < totDataLen) {
                plen = this.getParameterBlockCount();
                if (plen > 0 && paramBuf != null) {
                    paramBuf.appendData(this.getBuffer(), this.getParameterBlockOffset(), plen);
                    if (Session.hasDebug()) {
                        Debug.println("  Receive param plen=" + plen + ", poff=" + this.getParameterBlockOffset());
                    }
                }
                if ((dlen = this.getDataBlockCount()) > 0 && dataBuf != null) {
                    dataBuf.appendData(this.getBuffer(), this.getDataBlockOffset(), dlen);
                    if (Session.hasDebug()) {
                        Debug.println("  Receive data dlen=" + dlen + ", doff=" + this.getDataBlockOffset());
                    }
                }
                if ((paramBuf == null || paramBuf.getUsedLength() >= totParamLen) && (dataBuf == null || dataBuf.getUsedLength() >= totDataLen)) continue;
                if (Session.hasDebug()) {
                    Debug.println("  Reading secondary trans pkt ...");
                }
                this.ReceiveSMB(sess, false);
                if (!this.isValidResponse()) {
                    this.checkForError();
                }
                totParamLen = this.getTotalParameterCount();
                totDataLen = this.getTotalDataCount();
            }
            if (Session.hasDebug()) {
                Debug.println("  Finished reading trans data respBuf=" + respBuf);
            }
            if (respBuf != null) {
                respBuf.setEndOfBuffer();
            }
        }
        finally {
            sess.setTransactionMID(-1);
        }
        return respBuf;
    }

    public final int getTotalParameterCount() {
        return this.getParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getParameter(1);
    }

    public final int getParameterBlockCount() {
        if (this.isResponse()) {
            return this.getParameter(3);
        }
        if (this.isType() == 37 || this.isType() == 50) {
            return this.getParameter(9);
        }
        return this.getParameter(2);
    }

    public final int getParameterBlockOffset() {
        int off = -1;
        if (this.isResponse()) {
            off = this.getParameter(4);
        } else if (this.isType() == 37 || this.isType() == 50) {
            off = this.getParameter(10);
        } else {
            return this.getParameter(3);
        }
        return off + 4;
    }

    public final int getDataBlockCount() {
        if (this.isResponse()) {
            return this.getParameter(6);
        }
        if (this.isType() == 37 || this.isType() == 50) {
            return this.getParameter(11);
        }
        return this.getParameter(5);
    }

    public final int getDataBlockOffset() {
        int off = -1;
        off = this.isResponse() ? this.getParameter(7) : (this.isType() == 37 || this.isType() == 50 ? this.getParameter(12) : this.getParameter(6));
        return off + 4;
    }

    public final void setSetupParameter(int idx, int val) {
        this.setParameter(14 + idx, val);
    }

    public final void setTransactionName(String tname) {
        this.m_transName = tname;
    }

    public final void setTotalParameterCount(int len) {
        this.setParameter(0, len);
    }

    public final void setTotalDataCount(int len) {
        this.setParameter(1, len);
    }

    public final void setMaximumParameterReturn(int len) {
        this.setParameter(2, len);
    }

    public final void setMaximumDataReturn(int len) {
        this.setParameter(3, len);
    }

    public final void setParameterBlockCount(int len) {
        this.setParameter(9, len);
    }

    public final void setParameterBlockOffset(int off) {
        this.setParameter(10, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockCount(int len) {
        this.setParameter(11, len);
    }

    public final void setDataBlockOffset(int off) {
        this.setParameter(12, off != 0 ? off - 4 : 0);
    }

    public final void setSetupCount(int cnt) {
        this.setParameter(13, cnt);
    }
}

