/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import org.alfresco.jlan.client.info.ExtendedFileInfo;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.client.info.StreamInfo;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataBuffer;

class FileInfoPacker {
    FileInfoPacker() {
    }

    protected static final FileInfo unpackFileInfoStandard(String fname, DataBuffer buf, boolean ea) {
        int cfdat = buf.getShort();
        int cftim = buf.getShort();
        int afdat = buf.getShort();
        int aftim = buf.getShort();
        int wfdat = buf.getShort();
        int wftim = buf.getShort();
        int fsiz = buf.getInt();
        int alloc = buf.getInt();
        int fattr = buf.getShort();
        int eaSize = 0;
        if (ea) {
            eaSize = buf.getInt();
        }
        FileInfo info = null;
        if (!ea) {
            info = new FileInfo(fname, fsiz, fattr, wfdat, wftim);
        } else {
            ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, fsiz, fattr, wfdat, wftim);
            extInfo.setExtendedAttributesSize(eaSize);
            info = extInfo;
        }
        if (cfdat != 0) {
            info.setCreationDateTime(cfdat, cftim);
        }
        if (afdat != 0) {
            info.setAccessDateTime(afdat, aftim);
        }
        info.setAllocationSize(alloc);
        return info;
    }

    protected static final void packFileInfoStandard(FileInfo finfo, DataBuffer buf, boolean ea) throws SMBException {
        if (ea && !(finfo instanceof ExtendedFileInfo)) {
            throw new SMBException(5, 8);
        }
        if (finfo.hasCreationDateTime()) {
            SMBDate cDate = finfo.getCreationDateTime();
            buf.putShort(cDate.asSMBTime());
            buf.putShort(cDate.asSMBDate());
        } else {
            buf.putZeros(4);
        }
        if (finfo.hasAccessDateTime()) {
            SMBDate aDate = finfo.getAccessDateTime();
            buf.putShort(aDate.asSMBTime());
            buf.putShort(aDate.asSMBDate());
        } else {
            buf.putZeros(4);
        }
        if (finfo.hasModifyDateTime()) {
            SMBDate mDate = finfo.getModifyDateTime();
            buf.putShort(mDate.asSMBTime());
            buf.putShort(mDate.asSMBDate());
        } else {
            buf.putZeros(4);
        }
        buf.putInt(finfo.getSizeInt());
        buf.putInt(finfo.getAllocationSizeInt());
        buf.putShort(finfo.getFileAttributes());
        if (ea) {
            ExtendedFileInfo extInfo = (ExtendedFileInfo)finfo;
            buf.putInt(extInfo.getExtendedAttributesSize());
        }
    }

    protected static final FileInfo unpackQueryStandardInfo(String fname, DataBuffer buf) {
        long fileSize = buf.getLong();
        long allocSize = buf.getLong();
        boolean delPending = buf.getByte() != 0;
        boolean isDirectory = buf.getByte() != 0;
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, fileSize, 0);
        extInfo.setAllocationSize(allocSize);
        extInfo.setDeletePending(delPending);
        return extInfo;
    }

    protected static final FileInfo unpackQueryEAInfo(String fname, DataBuffer buf) {
        int eaSize = buf.getInt();
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, 0L, 0);
        extInfo.setExtendedAttributesSize(eaSize);
        return extInfo;
    }

    protected static final FileInfo unpackQueryNameInfo(DataBuffer buf, boolean uni) {
        buf.getInt();
        String name = buf.getString(uni);
        ExtendedFileInfo finfo = new ExtendedFileInfo(name, 0L, 0);
        return finfo;
    }

    protected static final FileInfo unpackQueryStreamInfo(String fname, DataBuffer buf, boolean uni) {
        int pos = buf.getPosition();
        int offset = buf.getInt();
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, 0L, 0);
        boolean endOfList = false;
        while (!endOfList) {
            int nameLen = buf.getInt();
            if (uni) {
                nameLen /= 2;
            }
            long strmSize = buf.getLong();
            long strmAlloc = buf.getLong();
            String name = buf.getString(nameLen, uni);
            StreamInfo stream = new StreamInfo(name, 0, 0, strmSize, strmAlloc);
            extInfo.addNTFSStreamInfo(stream);
            if (offset == 0) {
                endOfList = true;
                continue;
            }
            buf.setPosition(pos += offset);
            offset = buf.getInt();
        }
        return extInfo;
    }

    protected static final FileInfo unpackQueryCompressionInfo(String fname, DataBuffer buf) {
        long compSize = buf.getLong();
        int compFmt = buf.getShort();
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, 0L, 0);
        extInfo.setCompressedSizeFormat(compSize, compFmt);
        return extInfo;
    }

    protected static final FileInfo unpackQueryAllInfo(DataBuffer buf, boolean uni) {
        long createTime = buf.getLong();
        long accessTime = buf.getLong();
        long writeTime = buf.getLong();
        long changeTime = buf.getLong();
        int attr = buf.getInt();
        buf.skipBytes(4);
        long allocSize = buf.getLong();
        long fileSize = buf.getLong();
        boolean delPending = buf.getByte() != 0;
        boolean isDir = buf.getByte() != 0;
        buf.skipBytes(2);
        int eaSize = buf.getInt();
        int nameLen = buf.getInt();
        if (uni) {
            nameLen /= 2;
        }
        String name = buf.getString(nameLen, uni);
        ExtendedFileInfo extInfo = new ExtendedFileInfo(name, fileSize, attr);
        extInfo.setAllocationSize(allocSize);
        extInfo.setDeletePending(delPending);
        extInfo.setExtendedAttributesSize(eaSize);
        SMBDate smbDate = null;
        if (createTime != 0L) {
            smbDate = NTTime.toSMBDate(createTime);
            extInfo.setCreationDateTime(smbDate);
        }
        if (accessTime != 0L) {
            smbDate = NTTime.toSMBDate(accessTime);
            extInfo.setAccessDateTime(smbDate);
        }
        if (writeTime != 0L) {
            smbDate = NTTime.toSMBDate(writeTime);
            extInfo.setModifyDateTime(smbDate);
        }
        return extInfo;
    }

    protected static final FileInfo unpackQueryBasicInfo(String fname, DataBuffer buf) {
        long createTime = buf.getLong();
        long accessTime = buf.getLong();
        long writeTime = buf.getLong();
        long changeTime = buf.getLong();
        int attr = buf.getInt();
        int eaSize = buf.getInt();
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, 0L, attr);
        extInfo.setExtendedAttributesSize(eaSize);
        SMBDate smbDate = null;
        if (createTime != 0L) {
            smbDate = NTTime.toSMBDate(createTime);
            extInfo.setCreationDateTime(smbDate);
        }
        if (accessTime != 0L) {
            smbDate = NTTime.toSMBDate(accessTime);
            extInfo.setAccessDateTime(smbDate);
        }
        if (writeTime != 0L) {
            smbDate = NTTime.toSMBDate(writeTime);
            extInfo.setModifyDateTime(smbDate);
        }
        return extInfo;
    }

    protected static final void packFileBasicInfo(FileInfo finfo, DataBuffer buf) throws SMBException {
        if (!(finfo instanceof ExtendedFileInfo)) {
            throw new SMBException(5, 8);
        }
        ExtendedFileInfo extInfo = (ExtendedFileInfo)finfo;
        if (extInfo.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(extInfo.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (extInfo.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(extInfo.getAccessDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (extInfo.hasModifyDateTime()) {
            buf.putLong(NTTime.toNTTime(extInfo.getModifyDateTime()));
            buf.putLong(NTTime.toNTTime(extInfo.getModifyDateTime()));
        } else {
            buf.putZeros(16);
        }
        buf.putInt(extInfo.getFileAttributes());
        buf.putInt(extInfo.getExtendedAttributesSize());
    }

    protected static final FileInfo unpackQueryAllEAs(String fname, DataBuffer buf) {
        ExtendedFileInfo extInfo = new ExtendedFileInfo(fname, 0L, 0);
        int eaSize = buf.getInt() - 4;
        byte[] eaData = null;
        if (eaSize > 0) {
            eaData = new byte[eaSize];
            System.arraycopy(buf.getBuffer(), buf.getPosition(), eaData, 0, eaSize);
        }
        extInfo.setExtendedAttributesSize(eaSize);
        extInfo.setExtendedAttributeData(eaData);
        return extInfo;
    }
}

