package com.cybelia.sandra.migration;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Version;

/**
 * Migration between version 0 and 1.0.
 *
 * @author sletellier
 */
public class MigrationV0V10 extends MigrationCallBackForVersion {

    public MigrationV0V10(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {

        // Purge queue
        queries.add("DELETE FROM sandra.\"values\";");
        queries.add("DELETE FROM sandra.cron_queue;");
        queries.add("DELETE FROM sandra.queue;");

        // Migration
        queries.add("UPDATE sandra.userindicateurs SET taasuser = userid;");
        queries.add("ALTER TABLE sandra.userindicateurs DROP COLUMN userid;");
        queries.add("INSERT INTO sandra.infoaccess_usersverrouillage(infoaccess, usersverrouillage) SELECT owner, usersverrouillageids FROM sandra.usersverrouillageids;");
        queries.add("DROP TABLE sandra.usersverrouillageids;");
        queries.add("UPDATE sandra.chauffeur SET nom=replace(nom, '�', 'E') where nom like '%�%';");

        // Clean security
        queries.add("DELETE FROM sandra.authorizations_principals " +
                    "WHERE authorizations IN (SELECT topiaid FROM " +
                        "sandra.taasauthorization WHERE expression != '*' AND " +
                        "topiaid IN (SELECT authorizations FROM " +
                        "sandra.authorizations_principals WHERE " +
                        "principals IN (select principals FROM " +
                            "sandra.principals_users WHERE users IN " +
                            "(SELECT topiaid FROM sandra.taasuser WHERE " +
                                "login IN ('notifier', 'scheduler')))));");

        queries.add("DELETE FROM sandra.taasauthorization WHERE " +
                    "expression != '*' AND topiaid IN (SELECT authorizations FROM " +
                        "sandra.authorizations_principals WHERE principals IN " +
                        "(SELECT principals FROM sandra.principals_users WHERE " +
                            "users IN (SELECT topiaid FROM sandra.taasuser WHERE " +
                                "login IN ('notifier', 'scheduler'))));");

        queries.add("DELETE FROM sandra.principals_users WHERE users = " +
                    "(SELECT topiaid FROM sandra.taasuser WHERE login = 'notifier');");

        queries.add("DELETE from sandra.taasprincipal WHERE topiaid IN (SELECT principals " +
                    "FROM sandra.principals_users WHERE users = (SELECT topiaid FROM " +
                        "sandra.taasuser WHERE login = 'notifier'));");

        queries.add("DELETE FROM sandra.userindicateurs WHERE taasuser = " +
                    "(select topiaId FROM sandra.taasuser WHERE login = 'notifier');");

        queries.add("DELETE FROM sandra.taasuser WHERE login = 'notifier';");

        // Get security configuration
        ApplicationConfig config = SandraConfig.getConfig();
        String securityPrincipal = SandraSchedulerConfigHelper.getSecurityPrincipal(config);
        String securityCredentials = SandraSchedulerConfigHelper.getSecurityCredentials(config);
        queries.add("UPDATE sandra.taasuser SET login='"+ securityPrincipal + "' where login='scheduler';");
        queries.add("UPDATE sandra.taasuser SET password='" + TaasUtil.hash(securityCredentials) +
                    "' where login='" + securityPrincipal + "';");
        queries.add("UPDATE sandra.taasprincipal SET name = '" + securityPrincipal + "' WHERE name='scheduler';");

        // Add relation between camion and userIndicateurs
        queries.add("UPDATE sandra.camion SET actif = '" + true + "';");
        queries.add("UPDATE sandra.camion c SET userIndicateurs = " +
                "(SELECT ui.topiaId FROM sandra.taasuser u, sandra.userIndicateurs ui, sandra.societe s " +
                "WHERE u.login = s.code || '-' || c.code AND c.societe = u.link AND u.topiaId = ui.taasUser AND s.topiaId = c.societe);");

    }
}
