package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuLabel;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaException;

/**
 * @author chemit
 */
public class InjectorLabel implements Injector {

    protected Label label;

    public Label getObject() {
        return label;
    }

    public void clear() {
        label = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        // do nothing
    }

    public void inject(ManagerInjector manager, IbuLabel ibuLabel) throws TopiaException {


        LabelDAO dao = SandraDAOHelper.getLabelDAO(manager.getTransaction());

        // Recherche
        label = dao.findByNaturalId(ibuLabel.getId(), ibuLabel.getCategory());

        if (label == null) {
            // creation
            label = dao.createByNaturalId(ibuLabel.getId(), ibuLabel.getCategory());
        }

        label.setValeur(ibuLabel.getValue());

        dao.update(label);
    }
}