package com.cybelia.sandra;

import com.cybelia.sandra.migration.SandraMigrationCallback;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.migration.TopiaMigrationEngine;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.quartz.CronExpression;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier
 */
public class SandraSchedulerConfigHelper {

    /**
     * Logger.
     */
    public static final Log log = LogFactory.getLog(SandraSchedulerConfigHelper.class);

    public static String getCSVDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_INJECTION_DIR.key);
    }

    public static String getPatternFile(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_PATTERN_FILE.key);
    }

    public static String getIbuPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_PATH.key);
    }

    public static String getIbuErrorPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_ERROR.key);
    }

    public static String getIbuVerifierErrorPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_VERIFIER_ERROR.key);
    }

    public static String getIbuOldPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_OLDS.key);
    }

    public static String getIbuWorkPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_WORK.key);
    }

    public static String getIbuDonePath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_DONE.key);
    }

    public static String getSuiviTourPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SUIVI_TOUR_PATH.key);
    }

    public static String getSandraName(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_NAME.key);
    }

    static public String getSandraUrl(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_URL.key);
    }

    public static String getSandraEmailHost(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_HOST.key);
    }

    public static int getSandraEmailPort(ApplicationConfig config) {
        return config.getOptionAsInt(SandraConfig.SandraOption.SANDRA_EMAIL_PORT.key);
    }

    public static String getSandraEmailTo(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_TO.key);
    }

    public static String getSandraEmailForm(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_FROM.key);
    }

    public static Locale getLocale(ApplicationConfig config) {
        return config.getOptionAsLocale(SandraConfig.SandraOption.LOCALE.key);
    }

    protected static Properties getTopiaProperties(ApplicationConfig config) throws IOException {
        return config.getOptionAsProperties(SandraConfig.SandraOption.SANDRA_TOPIA_PROPERTIES.key);
    }

    protected static Set<Class<?>> getSandraImplementationClasses() {

        // Add sandra persistance classes
        Class<?>[] sandraImplementationClasses = SandraDAOHelper.getImplementationClasses();
        Set<Class<?>> sandraImplementationClassesSet = new HashSet<Class<?>>(Arrays.asList(sandraImplementationClasses));

        // Add topia security persistances classes
        sandraImplementationClassesSet.addAll(Arrays.asList(TaasService.getTaasPersistenceClasses()));

        return sandraImplementationClassesSet;
    }

    protected static Properties addTopiaPersistenceClassesToProperties(Properties topiaProperties, Set<Class<?>> implementationClasses) {
        StringUtil.ToString<Class<?>> classToString = new StringUtil.ToString<Class<?>>() {

            @Override
            public String toString(Class<?> aClass) {
                return aClass.getName();
            }
        };

        topiaProperties.put(TopiaContextFactory.CONFIG_PERSISTENCE_CLASSES,
                StringUtil.join(implementationClasses,
                        classToString, ", ", true));

        return topiaProperties;
    }

    public static Properties getSchedulerTopiaProperties(ApplicationConfig config) throws IOException {
        Properties topiaProperties = getTopiaProperties(config);

        // Add sandra entities
        Set<Class<?>> sandraImplementationClasses = getSandraImplementationClasses();

        // Join
        Properties properties = addTopiaPersistenceClassesToProperties(topiaProperties, sandraImplementationClasses);

        // Add migration service config
        properties.put(TopiaMigrationService.TOPIA_SERVICE_NAME, TopiaMigrationEngine.class.getName());
        properties.put(TopiaMigrationService.MIGRATION_CALLBACK, SandraMigrationCallback.class.getName());
        properties.put(TopiaMigrationService.MIGRATION_SHOW_SQL, String.valueOf(true));
        properties.put(TopiaMigrationService.MIGRATION_SHOW_PROGRESSION, String.valueOf(true));

        return properties;
    }

    public static TopiaContext getSchedulerRootContext() throws IOException, TopiaNotFoundException {
        ApplicationConfig config = SandraConfig.getConfig();
        return TopiaContextFactory.getContext(SandraSchedulerConfigHelper.getSchedulerTopiaProperties(config));
    }

    public static File getTemplateFile(ApplicationConfig config, String name) {
        return new File(getNotifierTemplateDir(config) + File.separator + name + getNotifierTemplateExt(config));
    }

    public static String getNotifierTemplateDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIFIER_TEMPLATE_DIR.key);
    }

    public static String getNotifierTemplateExt(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIFIER_TEMPLATE_EXTENSION.key);
    }

    public static String getNotifPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIF_PATH.key);
    }

    public static String getCronfromProperies(ApplicationConfig config, String pattern) throws ParseException {

        // Recherche la frequance des notifications dans le fichier de propriete de sandra
        return config.getOption(pattern + ".cron");
    }

    public static Date getNextDatefromProperies(ApplicationConfig config, String pattern) throws ParseException {

        // Recherche la frequance des notifications dans le fichier de propriete de sandra
        String expression = getCronfromProperies(config, pattern);

        if (expression == null) {
            log.warn("No next date found for " + _(pattern));
            return null;
        }

        // Creation de la date de la future notification
        CronExpression cronExpression = new CronExpression(expression);
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.MINUTE, 1);
        Date next = cronExpression.getNextValidTimeAfter(cal.getTime());

        return next;
    }

    public static String getSecurityPrincipal(ApplicationConfig config) {
        return config.getOption(Context.SECURITY_PRINCIPAL);
    }

    public static String getSecurityCredentials(ApplicationConfig config) {
        return config.getOption(Context.SECURITY_CREDENTIALS);
    }
}
