/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.controller.v1;

import fr.ird.observe.services.dto.UnauthorizedException;
import fr.ird.observe.services.http.ObserveHttpError;
import fr.ird.observe.services.security.ObserveWebSecurityExceptionSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import org.debux.webmotion.server.WebMotionController;
import org.debux.webmotion.server.WebMotionException;
import org.debux.webmotion.server.call.HttpContext;

public class ObserveWebErrorController
extends WebMotionController {
    public ObserveHttpError error(HttpContext.ErrorData errorData) {
        Throwable exception = errorData.getException();
        if (exception instanceof WebMotionException) {
            if (exception.getCause() == exception) {
                exception.initCause(null);
            } else {
                exception = exception.getCause();
            }
        }
        if (exception instanceof InvocationTargetException) {
            exception = exception.getCause();
        }
        Integer statusCode = errorData.getStatusCode();
        String message = errorData.getMessage();
        if (exception != null) {
            LinkedHashSet<StackTraceElement> stackTraceElements = new LinkedHashSet<StackTraceElement>();
            if (exception.getStackTrace() != null) {
                for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                    if (stackTraceElement.getClassName().contains("sun.reflect.")) continue;
                    stackTraceElements.add(stackTraceElement);
                }
            }
            if (exception instanceof UnauthorizedException) {
                statusCode = 403;
            }
            if (exception instanceof ObserveWebSecurityExceptionSupport) {
                statusCode = 401;
            }
            exception.setStackTrace(stackTraceElements.toArray(new StackTraceElement[stackTraceElements.size()]));
            message = exception.getMessage();
        }
        return new ObserveHttpError(statusCode, exception == null ? null : exception.getClass(), message, exception);
    }
}

