/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompConfiguration.java 263 2012-02-09 13:10:48Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompConfiguration.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyConfigOption;

import java.io.File;
import java.util.Locale;
import java.util.Properties;

/**
 * User: couteau
 * Date: 26 nov. 2010
 */
public class RefcompConfiguration {

    /**
     * log.
     */
    private static final Log log = LogFactory.getLog(RefcompConfiguration.class);

    protected ApplicationConfig applicationConfig;

    public RefcompConfiguration(String... args) {
        applicationConfig = new ApplicationConfig();
        // Load defaults wikitty options
        applicationConfig.loadDefaultOptions(WikittyConfigOption.class);

        // Load defaults refcomp options
        applicationConfig.loadDefaultOptions(RefcompConfigurationOption.class);

        // Load actions
        applicationConfig.loadActions(RefcompServiceActionDef.class);
        applicationConfig.setConfigFileName("refcomp.properties");
        try {
            applicationConfig.parse(args);
        } catch (ArgumentsParserException e) {
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("parsed options in config file" + applicationConfig.getOptions());
        }

    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    /*public static synchronized RefcompConfiguration getInstance(String... args) {
        if (instance == null) {
            try {
                instance = new RefcompConfiguration();
                instance.parse(args);
                // was done in parse before (but not good for tests)
                instance.setSystemDefaultProps();
                if (log.isDebugEnabled()){
                    log.debug("Configuration initialized");
                }
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't intitialize configuration", ex);
                }
                throw new UnhandledException(ex);
            }
        }
        return instance;
    }*/

    /**
     * Set {@code solr} and {@code jms} system configuration.
     * <p/>
     * This is the "only" way to configure embedded solr.
     */
    protected void setSystemDefaultProps() {
        String[] datadirs = new String[]{"solr.data.dir", "refcomp.objectStore.dir"};

        for (String datadir : datadirs) {
            String value = System.getProperty(datadir, null);
            if (value == null) {
                value = applicationConfig.getOption(datadir);
                if (log.isInfoEnabled()) {
                    log.info("Setting system property " + datadir + " : " + value);
                }
                if (value != null) {
                    System.setProperty(datadir, value);
                    //env.put(datadir, value);
                }
            }
        }
    }

    public static final String DATA_DEFAULT_DIR = "${user.home}" + File.separator + ".refcomp" +
            File.separator + "refcomp-${application.version}";

    public String getApplicationVersion() {
        return applicationConfig.getOption(RefcompConfigurationOption.APPLICATION_VERSION.getKey());
    }

    public String getDataDir(ApplicationConfig config) {
        String option = config.getOption(RefcompConfigurationOption.DATA_DIR.getKey());
        return option;
    }

    public File getDataDirAsFile() {
        File option = applicationConfig.getOptionAsFile(RefcompConfigurationOption.DATA_DIR.getKey());
        return option;
    }

    public Locale getLocale() {
        Locale result = applicationConfig.getOption(Locale.class, RefcompConfigurationOption.LOCALE.getKey());
        return result;
    }

    public void setLocale(Locale locale) {
        applicationConfig.setOption(RefcompConfigurationOption.LOCALE.getKey(), locale.toString());
    }

    public String getAdminEmail(){
        String email = applicationConfig.getOption(RefcompConfigurationOption.ADMIN_EMAIL.getKey());
        return email;
    }

    public String getAdminLogin(){
        String email = applicationConfig.getOption(RefcompConfigurationOption.ADMIN_LOGIN.getKey());
        return email;
    }

    public String getAdminPassword(){
        String email = applicationConfig.getOption(RefcompConfigurationOption.ADMIN_PASSWORD.getKey());
        return email;
    }

    public Properties getProperties() {
        return applicationConfig.getFlatOptions();
    }
}
