/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTypes;

public class FieldFactory {
    protected ExtensionFactory parentFactory;
    protected String fieldName;
    protected WikittyTypes type;
    protected int minOccur = 0;
    protected int maxOccur = 1;
    protected boolean unique = false;
    protected Map<String, String> tagValues = new HashMap<String, String>();

    public FieldFactory(ExtensionFactory parentFactory, String fieldName, WikittyTypes type) {
        this.parentFactory = parentFactory;
        this.fieldName = fieldName;
        this.type = type;
    }

    public FieldFactory addField(String name, WikittyTypes type) {
        this.append();
        return this.parentFactory.addField(name, type);
    }

    public WikittyExtension extension() {
        this.append();
        return this.parentFactory.extension();
    }

    protected void append() {
        FieldType fieldType = new FieldType(this.type, this.minOccur, this.maxOccur);
        for (Map.Entry<String, String> entry : this.tagValues.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            fieldType.addTagValue(tag, value);
        }
        this.parentFactory.add(this.fieldName, fieldType);
    }

    public FieldFactory maxOccur(int max) {
        this.maxOccur = max;
        return this;
    }

    public FieldFactory minOccur(int min) {
        this.minOccur = min;
        return this;
    }

    public FieldFactory unique() {
        this.addTagValue("unique", "true");
        return this;
    }

    public FieldFactory notNull() {
        this.addTagValue("notNull", "true");
        return this;
    }

    public FieldFactory crypt(String algo, String password) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            algo = algo + ":" + password;
        }
        this.addTagValue("crypt", "true");
        return this;
    }

    public FieldFactory allowed(String values) {
        this.addTagValue("allowed", values);
        return this;
    }

    public FieldFactory allowedQuery(String allowedQuery) {
        this.addTagValue("allowedQuery", allowedQuery);
        return this;
    }

    public FieldFactory choice(String values) {
        this.addTagValue("choice", values);
        return this;
    }

    public FieldFactory choiceQuery(String choiceQuery) {
        this.addTagValue("choiceQuery", choiceQuery);
        return this;
    }

    public FieldFactory indexed() {
        this.addTagValue("indexed", "true");
        return this;
    }

    public FieldFactory notIndexed() {
        this.addTagValue("indexed", "false");
        return this;
    }

    public FieldFactory pattern(String pattern) {
        this.addTagValue("pattern", pattern);
        return this;
    }

    public FieldFactory subtype(String type) {
        this.addTagValue("subtype", type);
        return this;
    }

    public FieldFactory min(String v) {
        this.addTagValue("min", v);
        return this;
    }

    public FieldFactory minQuery(String query) {
        this.addTagValue("minQuery", query);
        return this;
    }

    public FieldFactory max(String v) {
        this.addTagValue("max", v);
        return this;
    }

    public FieldFactory maxQuery(String query) {
        this.addTagValue("maxQuery", query);
        return this;
    }

    public FieldFactory addTagValue(String tag, String value) {
        this.tagValues.put(tag, value);
        return this;
    }
}

