/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittySecurityUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

@Deprecated
public class WikittyProxy {
    private static final Log log = LogFactory.getLog(WikittyProxy.class);
    private static final TimeLog timeLog = new TimeLog(WikittyProxy.class);
    protected WikittyServiceEnhanced wikittyService;
    protected String securityToken;

    public WikittyProxy() {
    }

    public WikittyProxy(ApplicationConfig config) {
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_PROXY_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_PROXY_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
    }

    public WikittyProxy(WikittyService wikittyService) {
        this();
        this.setWikittyService(wikittyService);
    }

    public WikittyProxy(ApplicationConfig config, WikittyService wikittyService) {
        this(config);
        this.setWikittyService(wikittyService);
    }

    public static TimeLog getTimeTrace() {
        return timeLog;
    }

    public static Map<String, TimeLog.CallStat> getCallCount() {
        return timeLog.getCallCount();
    }

    public void login(String login, String password) {
        long start = TimeLog.getTime();
        String result = this.wikittyService.login(login, password);
        this.setSecurityToken(result);
        timeLog.log(start, "login");
    }

    public void logout() {
        long start = TimeLog.getTime();
        this.wikittyService.logout(this.securityToken);
        timeLog.log(start, "logout");
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public WikittyUser getUser() {
        WikittyUser result = this.getUser(WikittyUser.class);
        return result;
    }

    public <E extends BusinessEntity> E getUser(Class<E> clazz) {
        Wikitty securityTokenWikitty;
        E result = null;
        if (this.securityToken != null && (securityTokenWikitty = this.restore(this.securityToken)) != null) {
            String userId = WikittyTokenHelper.getUser(securityTokenWikitty);
            result = this.restore(clazz, userId);
        }
        return result;
    }

    public WikittyService getWikittyService() {
        return this.wikittyService.getDelegate();
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.wikittyService = new WikittyServiceEnhanced(wikittyService);
    }

    public <E extends BusinessEntity> E cast(BusinessEntity source, Class<E> target) {
        long start = TimeLog.getTime();
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, target, ((BusinessEntityImpl)source).getWikitty());
        timeLog.log(start, "cast");
        return result;
    }

    public <E extends BusinessEntity> E store(E e) {
        Wikitty w = ((BusinessEntityImpl)e).getWikitty();
        this.store(w);
        return e;
    }

    public Wikitty store(Wikitty w) {
        long start = TimeLog.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, w);
        resp.update(w);
        timeLog.log(start, "store");
        return w;
    }

    public <E extends BusinessEntity> List<E> store(E e1, E e2, E ... eN) {
        ArrayList es = new ArrayList(eN.length + 2);
        Collections.addAll(es, e1, e2);
        Collections.addAll(es, eN);
        List result = this.store(es);
        return result;
    }

    public Wikitty[] store(Wikitty w1, Wikitty w2, Wikitty ... wN) {
        ArrayList<Wikitty> ws = new ArrayList<Wikitty>(wN.length + 2);
        Collections.addAll(ws, w1, w2);
        Collections.addAll(ws, wN);
        List<Wikitty> resultList = this.storeWikitty(ws);
        Wikitty[] result = resultList.toArray(new Wikitty[resultList.size()]);
        return result;
    }

    public <E extends BusinessEntity> List<E> store(List<E> objets) {
        long start = TimeLog.getTime();
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(objets.size());
        for (BusinessEntity e : objets) {
            if (e == null) {
                wikitties.add(null);
                continue;
            }
            Wikitty w = ((BusinessEntityImpl)e).getWikitty();
            wikitties.add(w);
        }
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeLog.log(start, "store<list>");
        return objets;
    }

    public List<Wikitty> storeWikitty(List<Wikitty> wikitties) {
        long start = TimeLog.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeLog.log(start, "storeWikitty<list>");
        return wikitties;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, boolean checkExtension) {
        try {
            long start = TimeLog.getTime();
            Object result = null;
            if (id != null) {
                HashSet<String> extNames = null;
                Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
                if (wikitty != null) {
                    if (checkExtension) {
                        extNames = new HashSet<String>(wikitty.getExtensionNames());
                    }
                    result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                    if (checkExtension) {
                        BusinessEntityImpl b = result;
                        Collection<WikittyExtension> BusinessEntityStaticExtensions = b.getStaticExtensions();
                        for (WikittyExtension ext : BusinessEntityStaticExtensions) {
                            String extensionName = ext.getName();
                            if (extNames.contains(extensionName)) continue;
                            result = null;
                            break;
                        }
                    }
                }
            }
            timeLog.log(start, "restore<Business>");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    public Wikitty restore(String id) {
        long start = TimeLog.getTime();
        Wikitty result = null;
        if (id != null) {
            result = this.wikittyService.restore(this.securityToken, id);
        }
        timeLog.log(start, "restore");
        return result;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id) {
        E result = this.restore(clazz, id, false);
        return result;
    }

    public List<Wikitty> restore(List<String> id) {
        long start = TimeLog.getTime();
        List<Object> result = id == null ? new ArrayList() : this.wikittyService.restore(this.securityToken, id);
        timeLog.log(start, "restoreWikitty<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, boolean checkExtension) {
        long start = TimeLog.getTime();
        ArrayList<E> result = new ArrayList<E>();
        if (id != null) {
            List<Wikitty> wikitties = this.wikittyService.restore(this.securityToken, id);
            for (Wikitty w : wikitties) {
                HashSet<String> extNames = null;
                if (checkExtension) {
                    extNames = new HashSet<String>(w.getExtensionNames());
                }
                E dto = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
                if (checkExtension) {
                    BusinessEntityImpl b = (BusinessEntityImpl)dto;
                    for (WikittyExtension ext : b.getStaticExtensions()) {
                        if (extNames.contains(ext.getName())) continue;
                        dto = null;
                        break;
                    }
                }
                if (dto == null) continue;
                result.add(dto);
            }
        }
        timeLog.log(start, "restore<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id) {
        List<E> result = this.restore(clazz, id, false);
        return result;
    }

    public Set<Wikitty> restore(Set<String> id) {
        ArrayList<String> list = null;
        if (id != null) {
            list = new ArrayList<String>(id);
        }
        List<Wikitty> resultList = this.restore(list);
        HashSet<Wikitty> result = new HashSet<Wikitty>(resultList);
        return result;
    }

    public <E extends BusinessEntity> Set<E> restore(Class<E> clazz, Set<String> id) {
        Set<E> result = this.restore(clazz, id, false);
        return result;
    }

    public <E extends BusinessEntity> Set<E> restore(Class<E> clazz, Set<String> id, boolean checkExtension) {
        ArrayList<String> list = null;
        if (id != null) {
            list = new ArrayList<String>(id);
        }
        List<E> resultList = this.restore(clazz, list, checkExtension);
        HashSet<E> result = new HashSet<E>(resultList);
        return result;
    }

    public void delete(String id) {
        long start = TimeLog.getTime();
        this.wikittyService.delete(this.securityToken, id);
        timeLog.log(start, "delete");
    }

    public <E extends BusinessEntity> void delete(E object) {
        long start = TimeLog.getTime();
        if (object != null) {
            String id = object.getWikittyId();
            this.wikittyService.delete(this.securityToken, id);
        }
        timeLog.log(start, "delete(BusinessEntity)");
    }

    public void delete(Collection<String> ids) {
        long start = TimeLog.getTime();
        this.wikittyService.delete(this.securityToken, ids);
        timeLog.log(start, "delete<list>");
    }

    public <E extends BusinessEntity> void delete(List<E> objets) {
        long start = TimeLog.getTime();
        ArrayList<String> ids = new ArrayList<String>(objets.size());
        for (BusinessEntity e : objets) {
            if (e == null) continue;
            String id = e.getWikittyId();
            ids.add(id);
        }
        this.wikittyService.delete(this.securityToken, ids);
        timeLog.log(start, "delete<list<BusinessEntity>>");
    }

    public <E extends BusinessEntityImpl> PagedResult<E> findAllByExample(E e, int firstIndex, int endIndex, String ... fieldFacet) {
        long start = TimeLog.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex).setFacetField(fieldFacet);
        PagedResult<String> pagedResult = this.findAllIdByCriteria(criteria);
        PagedResult<?> result = pagedResult.cast(this, e.getClass(), true);
        timeLog.log(start, "findAllByExample<limit>");
        return result;
    }

    public <E extends BusinessEntityImpl> E findByExample(E e) {
        long start = TimeLog.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        String id = this.findIdByCriteria(criteria);
        BusinessEntityImpl result = null;
        if (id != null) {
            Wikitty w = this.wikittyService.restore(this.securityToken, id);
            result = (BusinessEntityImpl)WikittyUtil.newInstance(this.securityToken, this.wikittyService, e.getClass(), w);
        }
        timeLog.log(start, "findByExample");
        return (E)result;
    }

    public <E extends BusinessEntity> List<PagedResult<E>> findAllByCriteria(Class<E> clazz, List<Criteria> criterias) {
        long start = TimeLog.getTime();
        ArrayList result = null;
        if (criterias != null) {
            BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
            Wikitty wikitty = sample.getWikitty();
            Collection<String> extensions = wikitty.getExtensionNames();
            ArrayList<Criteria> serviceCriterias = new ArrayList<Criteria>(criterias.size());
            for (Criteria criteria : criterias) {
                Criteria serviceCriteria = null;
                if (criteria != null) {
                    serviceCriteria = criteria.clone();
                    if (StringUtils.isEmpty((CharSequence)criteria.getSelect())) {
                        Search search = Search.query(criteria);
                        search = search.exteq(extensions);
                        serviceCriteria.setRestriction(search);
                    }
                }
                serviceCriterias.add(serviceCriteria);
            }
            List<PagedResult<String>> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, serviceCriterias);
            result = new ArrayList(pagedResult.size());
            for (PagedResult<String> p : pagedResult) {
                result.add(p.cast(this, sample.getClass(), true));
            }
        }
        timeLog.log(start, "findAllByCriteria<Business>(List)");
        return result;
    }

    public <E extends BusinessEntity> PagedResult<E> findAllByCriteria(Class<E> clazz, Criteria criteria) {
        long start = TimeLog.getTime();
        PagedResult<E> result = this.findAllByCriteria(clazz, Collections.singletonList(criteria)).get(0);
        timeLog.log(start, "findAllByCriteria<Business>(One)");
        return result;
    }

    public <E extends BusinessEntity> PagedResult<E>[] findAllByCriteria(Class<E> clazz, Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<PagedResult<E>> resultList = this.findAllByCriteria(clazz, criterias);
        PagedResult[] result = resultList.toArray(new PagedResult[criterias.size()]);
        timeLog.log(start, "findAllByCriteria<Business>(Varargs)");
        return result;
    }

    public List<PagedResult<Wikitty>> findAllByCriteria(List<Criteria> criteria) {
        long start = TimeLog.getTime();
        ArrayList<PagedResult<Wikitty>> result = null;
        if (criteria != null) {
            List<PagedResult<String>> resultId = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
            result = new ArrayList<PagedResult<Wikitty>>(resultId.size());
            for (PagedResult<String> p : resultId) {
                result.add(p.cast(this.securityToken, this.wikittyService));
            }
        }
        timeLog.log(start, "findAllByCriteria(List)");
        return result;
    }

    public PagedResult<Wikitty> findAllByCriteria(Criteria criteria) {
        long start = TimeLog.getTime();
        PagedResult<Wikitty> result = null;
        if (criteria != null) {
            result = this.findAllByCriteria(Collections.singletonList(criteria)).get(0);
        }
        timeLog.log(start, "findAllByCriteria(One)");
        return result;
    }

    public PagedResult<Wikitty>[] findAllByCriteria(Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<PagedResult<Wikitty>> resultList = this.findAllByCriteria(criterias);
        PagedResult[] result = resultList.toArray(new PagedResult[criterias.size()]);
        timeLog.log(start, "findAllByCriteria(Varargs)");
        return result;
    }

    public List<PagedResult<String>> findAllIdByCriteria(List<Criteria> criteria) {
        long start = TimeLog.getTime();
        List<PagedResult<String>> result = null;
        if (criteria != null) {
            result = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        }
        timeLog.log(start, "findAllIdByCriteria(List)");
        return result;
    }

    public PagedResult<String> findAllIdByCriteria(Criteria criteria) {
        long start = TimeLog.getTime();
        PagedResult<String> result = null;
        if (criteria != null) {
            result = this.findAllIdByCriteria(Collections.singletonList(criteria)).get(0);
        }
        timeLog.log(start, "findAllIdByCriteria(One)");
        return result;
    }

    public PagedResult<String>[] findAllIdByCriteria(Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<PagedResult<String>> resultList = this.findAllIdByCriteria(criterias);
        PagedResult[] result = resultList.toArray(new PagedResult[criterias.size()]);
        timeLog.log(start, "findAllIdByCriteria(Varargs)");
        return result;
    }

    public List<String> findIdByCriteria(List<Criteria> criteria) {
        long start = TimeLog.getTime();
        List<String> result = null;
        if (criteria != null) {
            result = this.wikittyService.findByCriteria(this.securityToken, criteria);
        }
        timeLog.log(start, "findIdByCriteria(List)");
        return result;
    }

    public String findIdByCriteria(Criteria criteria) {
        long start = TimeLog.getTime();
        String result = null;
        if (criteria != null) {
            result = this.findIdByCriteria(Collections.singletonList(criteria)).get(0);
        }
        timeLog.log(start, "findIdByCriteria(One)");
        return result;
    }

    public String[] findIdByCriteria(Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<String> resultList = this.findIdByCriteria(criterias);
        String[] result = resultList.toArray(new String[criterias.size()]);
        timeLog.log(start, "findIdByCriteria(Varargs)");
        return result;
    }

    public <E extends BusinessEntity> List<E> findByCriteria(Class<E> clazz, List<Criteria> criterias) {
        long start = TimeLog.getTime();
        List<E> result = null;
        if (criterias != null) {
            BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
            Wikitty wikitty = sample.getWikitty();
            Collection<String> extensions = wikitty.getExtensionNames();
            ArrayList<Criteria> serviceCriterias = new ArrayList<Criteria>(criterias.size());
            for (Criteria criteria : criterias) {
                Search search = Search.query(criteria);
                search = search.exteq(extensions);
                criteria = search.criteria();
                serviceCriterias.add(criteria);
            }
            List<String> id = this.findIdByCriteria(serviceCriterias);
            result = this.restore(clazz, id);
        }
        timeLog.log(start, "multiFindByCriteria<Business>(List>");
        return result;
    }

    public <E extends BusinessEntity> E findByCriteria(Class<E> clazz, Criteria criteria) {
        List<E> criterias;
        long start = TimeLog.getTime();
        BusinessEntity result = null;
        if (criteria != null && !(criterias = this.findByCriteria(clazz, Collections.singletonList(criteria))).isEmpty()) {
            result = (BusinessEntity)criterias.get(0);
        }
        timeLog.log(start, "findByCriteria<Business>(One)");
        return (E)result;
    }

    public <E extends BusinessEntity> E[] findByCriteria(Class<E> clazz, Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<E> resultList = this.findByCriteria(clazz, criterias);
        BusinessEntity[] result = resultList.toArray((BusinessEntity[])Array.newInstance(clazz, resultList.size()));
        timeLog.log(start, "findByCriteria<Business>(One)");
        return result;
    }

    public List<Wikitty> findByCriteria(List<Criteria> criteria) {
        long start = TimeLog.getTime();
        List<Wikitty> result = null;
        if (criteria != null) {
            List<String> id = this.findIdByCriteria(criteria);
            result = this.restore(id);
        }
        timeLog.log(start, "findByCriteria(List)");
        return result;
    }

    public Wikitty findByCriteria(Criteria criteria) {
        long start = TimeLog.getTime();
        String id = this.findIdByCriteria(criteria);
        Wikitty wikitty = this.restore(id);
        timeLog.log(start, "findByCriteria(One)");
        return wikitty;
    }

    public Wikitty[] findByCriteria(Criteria c1, Criteria c2, Criteria ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<String> resultList = this.findIdByCriteria(criterias);
        List<Wikitty> wikitties = this.restore(resultList);
        Wikitty[] result = wikitties.toArray(new Wikitty[resultList.size()]);
        timeLog.log(start, "findByCriteria(One)");
        return result;
    }

    public TreeNodeResult<Wikitty> findTreeNode(String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeLog.getTime();
        TreeNodeResult<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
        resultId.acceptVisitor(retrieveIdVisitor);
        List<String> ids = retrieveIdVisitor.getIds();
        List<Wikitty> wikitties = this.restore(ids);
        IdToObjectConverter<Wikitty> converter = new IdToObjectConverter<Wikitty>(ids, wikitties);
        ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
        resultId.acceptVisitor(convertVisitor);
        TreeNodeResult<Wikitty> result = convertVisitor.getTree();
        timeLog.log(start, "findTreeNode<Wikitty>");
        return result;
    }

    public <E extends BusinessEntity> TreeNodeResult<E> findTreeNode(Class<E> clazz, String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeLog.getTime();
        TreeNodeResult<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
        resultId.acceptVisitor(retrieveIdVisitor);
        List<String> ids = retrieveIdVisitor.getIds();
        List<E> wikitties = this.restore(clazz, ids);
        IdToObjectConverter<E> converter = new IdToObjectConverter<E>(ids, wikitties);
        ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
        resultId.acceptVisitor(convertVisitor);
        TreeNodeResult result = convertVisitor.getTree();
        timeLog.log(start, "findTreeNode");
        return result;
    }

    public TreeNodeResult<String> findAllIdTreeNode(String wikittyId, int depth, boolean count, Criteria filter) {
        long start = TimeLog.getTime();
        TreeNodeResult<String> result = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        timeLog.log(start, "findAllIdTreeNode");
        return result;
    }

    public WikittyEvent deleteTree(String treeNodeId) {
        long start = TimeLog.getTime();
        WikittyEvent result = this.wikittyService.deleteTree(this.securityToken, treeNodeId);
        timeLog.log(start, "deleteTree");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter) {
        long start = TimeLog.getTime();
        TreeNodeResult<E> tree = this.findTreeNode(clazz, wikittyId, 0, true, filter);
        AbstractMap.SimpleEntry<E, Integer> result = new AbstractMap.SimpleEntry<E, Integer>(tree.getObject(), tree.getAttCount());
        timeLog.log(start, "restoreNode");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map.Entry<E, Integer> result = this.restoreNode(clazz, wikittyId, filter);
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map<E, Integer> findTreeNode(Class<E> clazz, String wikittyId, Criteria filter) {
        long start = TimeLog.getTime();
        TreeNodeResult<E> tree = this.findTreeNode(clazz, wikittyId, 1, true, filter);
        LinkedHashMap<E, Integer> result = new LinkedHashMap<E, Integer>();
        for (TreeNodeResult<E> child : tree.getChildren()) {
            result.put(child.getObject(), child.getAttCount());
        }
        timeLog.log(start, "findTreeNode");
        return result;
    }

    @Deprecated
    public <E extends BusinessEntity> Map<E, Integer> findTreeNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map<E, Integer> result = this.findTreeNode(clazz, wikittyId, filter);
        return result;
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        long start = TimeLog.getTime();
        Wikitty result = this.wikittyService.restoreVersion(this.securityToken, wikittyId, version);
        timeLog.log(start, "restoreVersion");
        return result;
    }

    public <E extends BusinessEntity> boolean hasType(Class<E> clazz, String wikittyId) {
        try {
            long start = TimeLog.getTime();
            boolean result = true;
            Wikitty wikitty = this.wikittyService.restore(this.securityToken, wikittyId);
            if (wikitty == null) {
                result = false;
            } else {
                HashSet<String> extNames = new HashSet<String>(wikitty.getExtensionNames());
                E businessObject = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                BusinessEntityImpl b = (BusinessEntityImpl)businessObject;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    result = false;
                    break;
                }
            }
            timeLog.log(start, "hasType");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't retrieve wikitty needed for hasType test", eee);
        }
    }

    public WikittyEvent storeExtension(WikittyExtension ext) {
        long start = TimeLog.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, ext);
        timeLog.log(start, "storeExtension");
        return response;
    }

    public WikittyEvent storeExtension(Collection<WikittyExtension> exts) {
        long start = TimeLog.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, exts);
        timeLog.log(start, "storeExtension<list>");
        return response;
    }

    public WikittyExtension restoreExtension(String extensionId) {
        long start = TimeLog.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtension(this.securityToken, extensionId);
        timeLog.log(start, "restoreExtension");
        return extension;
    }

    public WikittyExtension restoreExtensionLastVersion(String extensionName) {
        long start = TimeLog.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtensionLastVersion(this.securityToken, extensionName);
        timeLog.log(start, "restoreExtensionLastVersion");
        return extension;
    }

    public List<WikittyExtension> restoreExtensionAndDependenciesLastVesion(Collection<String> extensionNames) {
        long start = TimeLog.getTime();
        List<WikittyExtension> result = this.wikittyService.restoreExtensionAndDependenciesLastVesion(this.securityToken, extensionNames);
        timeLog.log(start, "restoreExtensionAndDependenciesLastVesion");
        return result;
    }

    public void deleteExtension(String extName) {
        long start = TimeLog.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extName);
        timeLog.log(start, "deleteExtension");
    }

    public void deleteExtension(Collection<String> extNames) {
        long start = TimeLog.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extNames);
        timeLog.log(start, "deleteExtension<list>");
    }

    public List<String> getAllExtensionIds() {
        long start = TimeLog.getTime();
        List<String> result = this.wikittyService.getAllExtensionIds(this.securityToken);
        timeLog.log(start, "getAllExtensionIds");
        return result;
    }

    public List<String> getAllExtensionsRequires(String extensionName) {
        long start = TimeLog.getTime();
        List<String> result = this.wikittyService.getAllExtensionsRequires(this.securityToken, extensionName);
        timeLog.log(start, "getAllExtensionsRequires");
        return result;
    }

    public WikittyEvent clear() {
        long start = TimeLog.getTime();
        WikittyEvent result = this.wikittyService.clear(this.securityToken);
        timeLog.log(start, "clear");
        return result;
    }

    public void syncSearchEngine() {
        long start = TimeLog.getTime();
        this.wikittyService.syncSearchEngine(this.securityToken);
        timeLog.log(start, "syncSearchEngine");
    }

    public Wikitty getWikitty(BusinessEntity entity) {
        long start = TimeLog.getTime();
        Wikitty result = WikittyUtil.getWikitty(this.wikittyService, this.securityToken, entity);
        timeLog.log(start, "getWikitty");
        return result;
    }

    public boolean isMember(String groupName) {
        long start = TimeLog.getTime();
        boolean result = false;
        WikittyUser user = this.getLoggedInUser();
        Search search = Search.query().eq(Element.ELT_EXTENSION, "WikittyGroup").eq("WikittyGroup.name", groupName);
        Criteria criteria = search.criteria();
        Wikitty group = this.findByCriteria(criteria);
        if (group != null && user != null) {
            result = WikittySecurityUtil.isMember(this.wikittyService, this.securityToken, user.getWikittyId(), group.getId());
        }
        timeLog.log(start, "isMember");
        return result;
    }

    public WikittyUser getLoggedInUser() {
        long start = TimeLog.getTime();
        String userId = WikittySecurityUtil.getUserForToken(this.wikittyService, this.securityToken);
        WikittyUser user = this.restore(WikittyUser.class, userId);
        timeLog.log(start, "getLoggedInUser");
        return user;
    }

    private static class ConvertTreeVisitor<TARGET extends Serializable>
    implements TreeNodeResult.Visitor<String> {
        protected Converter<String, TARGET> converter;
        protected TreeNodeResult<TARGET> tree = null;
        protected LinkedList<TreeNodeResult<TARGET>> stack = new LinkedList();

        public ConvertTreeVisitor(Converter<String, TARGET> converter) {
            this.converter = converter;
            if (converter == null) {
                throw new IllegalArgumentException("Converter can't be null");
            }
        }

        public TreeNodeResult<TARGET> getTree() {
            return this.tree;
        }

        @Override
        public boolean visitEnter(TreeNodeResult<String> node) {
            String id = node.getObject();
            int count = node.getAttCount();
            Serializable object = (Serializable)this.converter.convert(id);
            TreeNodeResult<Serializable> newNode = new TreeNodeResult<Serializable>(object, count);
            TreeNodeResult<TARGET> parent = this.stack.peekLast();
            if (parent == null) {
                this.tree = newNode;
            } else {
                parent.add(newNode);
            }
            this.stack.offerLast(newNode);
            return true;
        }

        @Override
        public boolean visitLeave(TreeNodeResult<String> node) {
            this.stack.pollLast();
            return true;
        }

        private static interface Converter<SOURCE, TARGET> {
            public TARGET convert(SOURCE var1);
        }
    }

    private static class IdToObjectConverter<T>
    implements ConvertTreeVisitor.Converter<String, T> {
        protected Map<String, T> objects = new HashMap<String, T>();
        protected String securityToken;
        protected WikittyService wikittyService;

        public IdToObjectConverter(List<String> ids, List<T> objectList) {
            for (int i = 0; i < ids.size(); ++i) {
                this.objects.put(ids.get(i), objectList.get(i));
            }
        }

        @Override
        public T convert(String id) {
            T result = this.objects.get(id);
            return result;
        }
    }

    private static class RetrieveIdVisitor
    implements TreeNodeResult.Visitor<String> {
        protected List<String> ids = new ArrayList<String>();

        private RetrieveIdVisitor() {
        }

        public List<String> getIds() {
            return this.ids;
        }

        @Override
        public boolean visitEnter(TreeNodeResult<String> node) {
            String id = node.getObject();
            this.ids.add(id);
            return true;
        }

        @Override
        public boolean visitLeave(TreeNodeResult<String> node) {
            return true;
        }
    }
}

