/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextField
extends FieldType {
    protected boolean autoGeneratePhraseQueries;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        if (schema.getVersion() > 1.1f) {
            this.properties &= 0xFFFFFFDF;
        }
        this.autoGeneratePhraseQueries = !(schema.getVersion() > 1.3f);
        String autoGeneratePhraseQueriesStr = args.remove("autoGeneratePhraseQueries");
        if (autoGeneratePhraseQueriesStr != null) {
            this.autoGeneratePhraseQueries = Boolean.parseBoolean(autoGeneratePhraseQueriesStr);
        }
        super.init(schema, args);
    }

    public boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return TextField.parseFieldQuery(parser, this.getQueryAnalyzer(), field.getName(), externalVal);
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public void setQueryAnalyzer(Analyzer analyzer) {
        this.queryAnalyzer = analyzer;
    }

    static Query parseFieldQuery(QParser parser, Analyzer analyzer, String field, String queryText) {
        TokenStream source;
        int phraseSlop = 0;
        boolean enablePositionIncrements = true;
        try {
            source = analyzer.reusableTokenStream(field, (Reader)new StringReader(queryText));
            source.reset();
        }
        catch (IOException e) {
            source = analyzer.tokenStream(field, (Reader)new StringReader(queryText));
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        CharTermAttribute termAtt = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        boolean success = false;
        try {
            buffer.reset();
            success = true;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (success) {
            if (buffer.hasAttribute(CharTermAttribute.class)) {
                termAtt = (CharTermAttribute)buffer.getAttribute(CharTermAttribute.class);
            }
            if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                posIncrAtt = (PositionIncrementAttribute)buffer.getAttribute(PositionIncrementAttribute.class);
            }
        }
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        boolean hasMoreTokens = false;
        if (termAtt != null) {
            try {
                hasMoreTokens = buffer.incrementToken();
                while (hasMoreTokens) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        severalTokensAtSamePosition = true;
                    }
                    hasMoreTokens = buffer.incrementToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (numTokens == 0) {
            return null;
        }
        if (numTokens == 1) {
            String term = null;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            return new TermQuery(new Term(field, term));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = new BooleanQuery(true);
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    TermQuery currentQuery = new TermQuery(new Term(field, term));
                    q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            mpq.setSlop(phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[0]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new Term(field, term));
            }
            if (enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[0]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[0]));
            }
            return mpq;
        }
        PhraseQuery pq = new PhraseQuery();
        pq.setSlop(phraseSlop);
        int position = -1;
        for (int i = 0; i < numTokens; ++i) {
            String term = null;
            int positionIncrement = 1;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
                if (posIncrAtt != null) {
                    positionIncrement = posIncrAtt.getPositionIncrement();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (enablePositionIncrements) {
                pq.add(new Term(field, term), position += positionIncrement);
                continue;
            }
            pq.add(new Term(field, term));
        }
        return pq;
    }
}

