/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.BeanValidatorEvent;
import org.nuiton.validator.bean.BeanValidatorListener;

public class BeanValidator<O> {
    public static final String BEAN_PROPERTY = "bean";
    public static final String CONTEXT_PROPERTY = "context";
    public static final String SCOPES_PROPERTY = "scopes";
    public static final String VALID_PROPERTY = "valid";
    public static final String CHANGED_PROPERTY = "changed";
    protected static final Log log = LogFactory.getLog(BeanValidator.class);
    protected O bean;
    protected BeanValidator<?> parentValidator;
    protected NuitonValidator<O> delegate;
    protected NuitonValidatorResult messages;
    protected boolean changed;
    protected boolean valid = true;
    protected boolean canValidate = true;
    protected Map<String, String> conversionErrors;
    protected PropertyChangeListener l;
    protected PropertyChangeSupport pcs;
    protected EventListenerList listenerList = new EventListenerList();
    protected final NuitonValidatorProvider validatorProvider;

    public BeanValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context) {
        this(validatorProvider, beanClass, context, NuitonValidatorScope.values());
    }

    public BeanValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context, NuitonValidatorScope ... scopes) {
        boolean javaBeanCompiliant = BeanUtil.isJavaBeanCompiliant(beanClass);
        if (!javaBeanCompiliant) {
            throw new IllegalArgumentException(beanClass.getName() + " is not JavaBean compiliant (" + "addPropertyChangeListener" + ", or " + "removePropertyChangeListener" + " method not found).");
        }
        this.validatorProvider = validatorProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.conversionErrors = new TreeMap<String, String>();
        this.rebuildDelegateValidator(beanClass, context, scopes);
        this.firePropertyChange(CONTEXT_PROPERTY, null, context);
        this.firePropertyChange(SCOPES_PROPERTY, null, scopes);
        this.l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanValidator.this.doValidate();
            }
        };
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.firePropertyChange(CHANGED_PROPERTY, null, changed);
    }

    public boolean isCanValidate() {
        return this.canValidate;
    }

    public void setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY, null, valid);
    }

    public O getBean() {
        return this.bean;
    }

    public void setBean(O bean) {
        O oldBean;
        block8: {
            oldBean = this.bean;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " : " + bean));
            }
            this.conversionErrors.clear();
            if (oldBean != null) {
                try {
                    BeanUtil.removePropertyChangeListener((PropertyChangeListener)this.l, oldBean);
                }
                catch (Exception eee) {
                    if (!log.isInfoEnabled()) break block8;
                    log.info((Object)("Can't register as listener for bean " + oldBean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
        this.bean = bean;
        this.setCanValidate(!this.getDelegate().getEffectiveFields().isEmpty() && bean != null);
        if (bean == null) {
            this.mergeMessages(null);
        } else {
            block9: {
                try {
                    BeanUtil.addPropertyChangeListener((PropertyChangeListener)this.l, bean);
                }
                catch (Exception eee) {
                    if (!log.isInfoEnabled()) break block9;
                    log.info((Object)("Can't register as listener for bean " + bean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
                }
            }
            this.validate();
        }
        this.setChanged(false);
        this.setValid(this.messages == null || this.messages.isValid());
        this.firePropertyChange(BEAN_PROPERTY, oldBean, bean);
    }

    public String getContext() {
        return this.delegate.getModel().getContext();
    }

    public void setContext(String context) {
        String oldContext = this.getContext();
        if (context == null && oldContext == null || context != null && context.equals(oldContext)) {
            return;
        }
        NuitonValidatorModel<O> validatorModel = this.delegate.getModel();
        NuitonValidatorScope[] scopes = validatorModel.getScopes().toArray(new NuitonValidatorScope[validatorModel.getScopes().size()]);
        this.rebuildDelegateValidator(validatorModel.getType(), context, scopes);
        this.firePropertyChange(CONTEXT_PROPERTY, oldContext, context);
    }

    public Set<NuitonValidatorScope> getScopes() {
        return this.delegate.getModel().getScopes();
    }

    public Set<NuitonValidatorScope> getEffectiveScopes() {
        return this.delegate.getEffectiveScopes();
    }

    public Set<String> getEffectiveFields() {
        return this.delegate.getEffectiveFields();
    }

    public Set<String> getEffectiveFields(NuitonValidatorScope scope) {
        return this.delegate.getEffectiveFields(scope);
    }

    public void setScopes(NuitonValidatorScope ... scopes) {
        Set<NuitonValidatorScope> oldScopes = this.getScopes();
        NuitonValidatorModel<O> validatorModel = this.delegate.getModel();
        this.rebuildDelegateValidator(validatorModel.getType(), validatorModel.getContext(), scopes);
        this.firePropertyChange(SCOPES_PROPERTY, oldScopes, scopes);
    }

    public Class<O> getType() {
        return this.delegate.getModel().getType();
    }

    protected void rebuildDelegateValidator(Class<O> beanType, String context, NuitonValidatorScope ... scopes) {
        if (this.bean != null) {
            this.setBean(null);
        }
        if (scopes == null || scopes.length == 0) {
            scopes = NuitonValidatorScope.values();
        }
        NuitonValidatorModel<O> validatorModel = this.validatorProvider.getModel(beanType, context, scopes);
        this.delegate = this.validatorProvider.newValidator(validatorModel);
    }

    public BeanValidator<?> getParentValidator() {
        return this.parentValidator;
    }

    public void setParentValidator(BeanValidator<?> parentValidator) {
        this.parentValidator = parentValidator;
    }

    public boolean hasFatalErrors() {
        boolean result = this.messages != null && this.messages.hasFatalMessages();
        return result;
    }

    public boolean hasErrors() {
        boolean result = this.messages != null && this.messages.hasErrorMessagess();
        return result;
    }

    public boolean hasWarnings() {
        boolean result = this.messages != null && this.messages.hasWarningMessages();
        return result;
    }

    public boolean hasInfos() {
        boolean result = this.messages != null && this.messages.hasInfoMessages();
        return result;
    }

    public boolean containsField(String fieldName) {
        Set<String> effectiveFields = this.getDelegate().getEffectiveFields();
        boolean result = effectiveFields.contains(fieldName);
        return result;
    }

    public boolean isValid(String fieldName) {
        if (this.messages == null) {
            return true;
        }
        boolean result = !this.messages.hasMessagesForScope(fieldName, NuitonValidatorScope.FATAL) && !this.messages.hasMessagesForScope(fieldName, NuitonValidatorScope.ERROR);
        return result;
    }

    public NuitonValidatorScope getHighestScope(String field) {
        if (this.messages == null) {
            return null;
        }
        NuitonValidatorScope scope = this.messages.getFieldHighestScope(field);
        return scope;
    }

    public <T> T convert(String fieldName, String value, Class<T> valueClass) {
        Object result;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName can not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("valueClass can not be null");
        }
        if (!this.isCanValidate() || value == null) {
            return null;
        }
        this.conversionErrors.remove(fieldName);
        try {
            Converter converter = ConverterUtil.getConverter(valueClass);
            if (converter == null) {
                throw new RuntimeException("could not find converter for the type " + valueClass);
            }
            result = converter.convert(valueClass, (Object)value);
        }
        catch (ConversionException e) {
            String s = Introspector.decapitalize(valueClass.getSimpleName());
            this.conversionErrors.put(fieldName, "error.convertor." + s);
            result = null;
            this.validate();
        }
        return (T)result;
    }

    public void doValidate() {
        this.validate();
        this.setValid(this.messages == null || this.messages.isValid());
        this.setChanged(true);
    }

    public void validate() {
        if (!this.isCanValidate()) {
            return;
        }
        NuitonValidatorResult result = this.getDelegate().validate(this.bean);
        for (Map.Entry<String, String> entry : this.conversionErrors.entrySet()) {
            String field = entry.getKey();
            List<String> errors = result.getErrorMessages(field);
            String conversionError = entry.getValue();
            if (errors != null) {
                errors.clear();
                errors.add(conversionError);
            } else {
                errors = Collections.singletonList(conversionError);
            }
            result.setMessagesForScope(NuitonValidatorScope.ERROR, field, errors);
        }
        this.mergeMessages(result);
        if (this.parentValidator != null) {
            boolean wasModified = this.parentValidator.isChanged();
            this.parentValidator.doValidate();
            if (!wasModified) {
                this.parentValidator.setChanged(false);
            }
        }
    }

    public String toString() {
        return super.toString() + "<beanClass:" + this.delegate.getModel().getType() + ", context:" + this.getContext() + ">";
    }

    public void addBeanValidatorListener(BeanValidatorListener listener) {
        this.listenerList.add(BeanValidatorListener.class, listener);
    }

    public void removeBeanValidatorListener(BeanValidatorListener listener) {
        this.listenerList.remove(BeanValidatorListener.class, listener);
    }

    public BeanValidatorListener[] getBeanValidatorListeners() {
        return (BeanValidatorListener[])this.listenerList.getListeners(BeanValidatorListener.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected BeanValidatorEvent createEvent(String field, NuitonValidatorScope scope, String[] toAdd, String[] toDelete) {
        BeanValidatorEvent evt = new BeanValidatorEvent(this, field, scope, toAdd, toDelete);
        return evt;
    }

    protected void fireFieldChanged(String field, NuitonValidatorScope scope, String[] toAdd, String[] toDelete) {
        BeanValidatorEvent evt = this.createEvent(field, scope, toAdd, toDelete);
        this.fireFieldChanged(evt);
    }

    protected void fireFieldChanged(BeanValidatorEvent evt) {
        for (BeanValidatorListener listener : (BeanValidatorListener[])this.listenerList.getListeners(BeanValidatorListener.class)) {
            listener.onFieldChanged(evt);
        }
    }

    protected void mergeMessages(NuitonValidatorResult newMessages) {
        if (newMessages == null && this.messages == null) {
            return;
        }
        Set<NuitonValidatorScope> scopes = this.getDelegate().getEffectiveScopes();
        ArrayList<BeanValidatorEvent> events = new ArrayList<BeanValidatorEvent>();
        for (NuitonValidatorScope scope : scopes) {
            this.mergeMessages(scope, newMessages, events);
        }
        if (newMessages != null) {
            this.messages = newMessages;
        }
        if (CollectionUtils.isNotEmpty(events)) {
            for (BeanValidatorEvent event : events) {
                this.fireFieldChanged(event);
            }
        }
    }

    protected void mergeMessages(NuitonValidatorScope scope, NuitonValidatorResult newMessages, List<BeanValidatorEvent> events) {
        if (newMessages == null) {
            List<String> fieldsForScope = this.messages.getFieldsForScope(scope);
            for (String field : fieldsForScope) {
                List<String> messagesForScope = this.messages.getMessagesForScope(field, scope);
                events.add(this.createEvent(field, scope, null, messagesForScope.toArray(new String[messagesForScope.size()])));
            }
            this.messages.clearMessagesForScope(scope);
        } else {
            List<String> messagesForScope;
            List<String> newFields = newMessages.getFieldsForScope(scope);
            if (this.messages == null) {
                for (String field : newFields) {
                    List<String> messagesForScope2 = newMessages.getMessagesForScope(field, scope);
                    events.add(this.createEvent(field, scope, messagesForScope2.toArray(new String[messagesForScope2.size()]), null));
                }
                return;
            }
            List<String> oldFields = this.messages.getFieldsForScope(scope);
            Iterator<String> itr = newFields.iterator();
            while (itr.hasNext()) {
                String newField = itr.next();
                if (oldFields.contains(newField)) continue;
                messagesForScope = newMessages.getMessagesForScope(newField, scope);
                events.add(this.createEvent(newField, scope, messagesForScope.toArray(new String[messagesForScope.size()]), null));
                itr.remove();
            }
            itr = oldFields.iterator();
            while (itr.hasNext()) {
                String oldField = itr.next();
                if (newFields.contains(oldField)) continue;
                messagesForScope = this.messages.getMessagesForScope(oldField, scope);
                events.add(this.createEvent(oldField, scope, null, messagesForScope.toArray(new String[messagesForScope.size()])));
                itr.remove();
            }
            for (String field : newFields) {
                List<String> newMessagesForScope = newMessages.getMessagesForScope(field, scope);
                List<String> oldMessagesForScope = this.messages.getMessagesForScope(field, scope);
                HashSet<String> toDelete = new HashSet<String>(oldMessagesForScope);
                toDelete.removeAll(newMessagesForScope);
                HashSet<String> toAdd = new HashSet<String>(newMessagesForScope);
                toAdd.removeAll(oldMessagesForScope);
                events.add(this.createEvent(field, scope, toAdd.isEmpty() ? null : toAdd.toArray(new String[toAdd.size()]), toDelete.isEmpty() ? null : toDelete.toArray(new String[toDelete.size()])));
            }
        }
    }

    protected NuitonValidator<O> getDelegate() {
        return this.delegate;
    }
}

