/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.Arrays;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;

public class Characters {
    private static final char[] NO_CHARS = new char[0];
    public static final Characters NONE = new Characters(false, NO_CHARS);
    public static final Characters ALL = new Characters(true, NO_CHARS);
    private final boolean subtractive;
    private final char[] chars;

    private Characters(boolean subtractive, char[] chars) {
        this.subtractive = subtractive;
        this.chars = Preconditions.checkArgNotNull(chars, "chars");
    }

    public boolean isSubtractive() {
        return this.subtractive;
    }

    public char[] getChars() {
        return this.chars;
    }

    public Characters add(char c) {
        return this.subtractive ? this.removeFromChars(c) : this.addToChars(c);
    }

    public Characters remove(char c) {
        return this.subtractive ? this.addToChars(c) : this.removeFromChars(c);
    }

    public boolean contains(char c) {
        return Characters.indexOf(this.chars, c) == -1 ? this.subtractive : !this.subtractive;
    }

    public Characters add(Characters other) {
        Preconditions.checkArgNotNull(other, "other");
        if (!this.subtractive && !other.subtractive) {
            return this.addToChars(other.chars);
        }
        if (this.subtractive && other.subtractive) {
            return this.retainAllChars(other.chars);
        }
        return this.subtractive ? this.removeFromChars(other.chars) : other.removeFromChars(this.chars);
    }

    public Characters remove(Characters other) {
        Preconditions.checkArgNotNull(other, "other");
        if (!this.subtractive && !other.subtractive) {
            return this.removeFromChars(other.chars);
        }
        if (this.subtractive && other.subtractive) {
            return new Characters(false, other.removeFromChars((char[])this.chars).chars);
        }
        return this.subtractive ? this.addToChars(other.chars) : this.retainAllChars(other.chars);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subtractive ? "![" : "[");
        for (char c : this.chars) {
            sb.append(StringUtils.escape(c));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Characters)) {
            return false;
        }
        Characters that = (Characters)o;
        return this.subtractive == that.subtractive && Characters.equivalent(this.chars, that.chars);
    }

    public int hashCode() {
        int result = this.subtractive ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.chars);
        return result;
    }

    private Characters addToChars(char[] chs) {
        Characters characters = this;
        for (char c : chs) {
            characters = characters.addToChars(c);
        }
        return characters;
    }

    private Characters addToChars(char c) {
        if (Characters.indexOf(this.chars, c) != -1) {
            return this;
        }
        char[] newChars = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, newChars, 0, this.chars.length);
        newChars[this.chars.length] = c;
        return new Characters(this.subtractive, newChars);
    }

    private Characters removeFromChars(char[] chs) {
        Characters characters = this;
        for (char c : chs) {
            characters = characters.removeFromChars(c);
        }
        return characters;
    }

    private Characters removeFromChars(char c) {
        int ix = Characters.indexOf(this.chars, c);
        if (ix == -1) {
            return this;
        }
        if (this.chars.length == 1) {
            return this.subtractive ? ALL : NONE;
        }
        char[] newChars = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, newChars, 0, ix);
        System.arraycopy(this.chars, ix + 1, newChars, ix, this.chars.length - ix - 1);
        return new Characters(this.subtractive, newChars);
    }

    private Characters retainAllChars(char[] chs) {
        Characters characters = this;
        for (char c : this.chars) {
            if (Characters.indexOf(chs, c) != -1) continue;
            characters = characters.removeFromChars(c);
        }
        return characters;
    }

    private static int indexOf(char[] chars, char c) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static boolean equivalent(char[] a, char[] b) {
        Preconditions.checkArgNotNull(a, "a");
        Preconditions.checkArgNotNull(b, "b");
        if (a == b) {
            return true;
        }
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        block0: for (int i = 0; i < length; ++i) {
            char ac = a[i];
            for (int j = 0; j < length; ++j) {
                if (ac == b[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static Characters of(char c) {
        return new Characters(false, new char[]{c});
    }

    public static Characters of(char ... chars) {
        return chars.length == 0 ? NONE : new Characters(false, (char[])chars.clone());
    }

    public static Characters of(String chars) {
        return StringUtils.isEmpty(chars) ? NONE : new Characters(false, chars.toCharArray());
    }

    public static Characters allBut(char c) {
        return new Characters(true, new char[]{c});
    }

    public static Characters allBut(char ... chars) {
        return chars.length == 0 ? ALL : new Characters(true, (char[])chars.clone());
    }

    public static Characters allBut(String chars) {
        return StringUtils.isEmpty(chars) ? ALL : new Characters(true, chars.toCharArray());
    }
}

