/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTagValue;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyAbstractGenerator
extends ObjectModelTransformerToJava
implements WikittyTagValue {
    private static final Log log = LogFactory.getLog(WikittyAbstractGenerator.class);
    protected Map<ObjectModelClass, ObjectModelClass> processedClasses = new HashMap<ObjectModelClass, ObjectModelClass>();
    protected Map<String, String> attributeToGetterName = new HashMap<String, String>();
    protected List<ObjectModelClass> entitiesWithInheritedOperations = new ArrayList<ObjectModelClass>();
    protected Map<ObjectModelClass, List<String>> requiredDependencyImports = new HashMap<ObjectModelClass, List<String>>();

    public void transformFromModel(ObjectModel model) {
        ArrayList<ObjectModelClass> modelBoth = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz) && !WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            modelBoth.add(clazz);
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClass = this.createAbstractClass(WikittyTransformerUtil.businessEntityToAbstractName(clazz), clazz.getPackageName());
            this.processedClasses.put(clazz, abstractClass);
            this.setSuperClass(abstractClass, "BusinessEntityImpl");
            this.addInterface((ObjectModelClassifier)abstractClass, clazz.getQualifiedName());
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                this.addMetaExtensionOperations(clazz, this.processedClasses.get(clazz));
                continue;
            }
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addInheritedOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClassForThisEntity = this.processedClasses.get(clazz);
            this.addImports(abstractClassForThisEntity);
            this.addConstructors(abstractClassForThisEntity);
            this.addConstants(clazz, abstractClassForThisEntity);
            this.addToString(clazz, abstractClassForThisEntity);
            Long serialVersionUIDs = GeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)clazz);
            this.addConstant((ObjectModelClassifier)abstractClassForThisEntity, "serialVersionUID", "long", serialVersionUIDs.toString() + "L", ObjectModelModifier.PRIVATE);
        }
        this.processedClasses.clear();
    }

    protected void addImports(ObjectModelClass clazz) {
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.BusinessEntity");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.BusinessEntityImpl");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.Wikitty");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyExtension");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.WikittyUtil");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUser");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUserAbstract");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUserImpl");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNode");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNodeAbstract");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNodeImpl");
        this.addImport((ObjectModelClassifier)clazz, List.class);
        this.addImport((ObjectModelClassifier)clazz, ArrayList.class);
        this.addImport((ObjectModelClassifier)clazz, Collection.class);
        this.addImport((ObjectModelClassifier)clazz, Collections.class);
        this.addImport((ObjectModelClassifier)clazz, Set.class);
        this.addImport((ObjectModelClassifier)clazz, Date.class);
        this.addImport((ObjectModelClassifier)clazz, LinkedHashSet.class);
    }

    protected void addConstructors(ObjectModelClass clazz) {
        ObjectModelOperation constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        super();\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setOperationBody(constructor, "\n        super(wikitty);\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.BusinessEntityImpl", "businessEntityImpl");
        this.setOperationBody(constructor, "\n        super(businessEntityImpl.getWikitty());\n");
    }

    protected void addConstants(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        this.addConstant((ObjectModelClassifier)abstractClass, "extensions", "List<WikittyExtension>", null, ObjectModelModifier.PUBLIC);
        this.addConstant((ObjectModelClassifier)abstractClass, "extension" + businessEntity.getName(), "WikittyExtension", null, ObjectModelModifier.PUBLIC);
        ObjectModelOperation getStaticExtensions = this.addOperation((ObjectModelClassifier)abstractClass, "getStaticExtensions", "Collection<WikittyExtension>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getStaticExtensions, "Override");
        this.setOperationBody(getStaticExtensions, "\n        return extensions;\n");
        ObjectModelOperation staticInitialization = this.addBlock((ObjectModelClassifier)abstractClass, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        ArrayList<String> buildFieldMapExtensionParameters = new ArrayList<String>();
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            String type;
            if (!attribute.isNavigable()) continue;
            String wikittyType = WikittyTransformerUtil.typeToWikittyColumn(attribute.getType());
            String multiplicity = "";
            if (attribute.getMinMultiplicity() != 1 || attribute.getMaxMultiplicity() != 1) {
                multiplicity = "[" + attribute.getMinMultiplicity() + "-" + (attribute.getMaxMultiplicity() == -1 ? "*" : Integer.valueOf(attribute.getMaxMultiplicity())) + "]";
            }
            if ((attribute.getMaxMultiplicity() > 1 || attribute.getMaxMultiplicity() < 0) && attribute.isUnique() && !attribute.getTagValues().containsKey("unique")) {
                attribute.getTagValues().put("unique", "true");
            }
            if (StringUtils.equals((CharSequence)"Wikitty", (CharSequence)wikittyType) && null == attribute.getTagValue("allowed") && !StringUtils.equals((CharSequence)"Wikitty", (CharSequence)(type = WikittyTransformerUtil.FQNtoSimpleName(attribute.getType())))) {
                attribute.getTagValues().put("allowed", type);
            }
            String tagvalue = "";
            for (Map.Entry tv : attribute.getTagValues().entrySet()) {
                tagvalue = tagvalue + " " + (String)tv.getKey() + "=\\\"" + StringEscapeUtils.escapeJava((String)((String)tv.getValue())) + "\\\"";
            }
            buildFieldMapExtensionParameters.add("                                             \"" + wikittyType + " " + attribute.getName() + "" + multiplicity + "" + tagvalue + "\"");
        }
        String extensionVersion = businessEntity.getTagValue("version");
        if (extensionVersion == null || "".equals(extensionVersion)) {
            extensionVersion = "1.0";
            log.warn((Object)("no version specified in model for " + businessEntity.getQualifiedName() + " using " + extensionVersion));
        }
        String requires = "";
        String requiresSep = "";
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            this.addImport((ObjectModelClassifier)abstractClass, superClass);
            this.addImport((ObjectModelClassifier)abstractClass, superClass.getQualifiedName() + "Abstract");
            requires = requires + requiresSep + WikittyTransformerUtil.classToExtensionVariableName(superClass, true);
            requiresSep = " + \",\" + ";
        }
        if (requires.isEmpty()) {
            requires = "(List)null";
        }
        String tagValues = StringEscapeUtils.escapeJava((String)WikittyTransformerUtil.tagValuesToString(businessEntity.getTagValues()));
        String buildFieldMapExtensionParametersInLine = StringUtils.join(buildFieldMapExtensionParameters, (String)", \n");
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, false);
        String staticInitializationBody = "\n        extension" + businessEntity.getName() + " = new WikittyExtension(" + extensionVariableName + ",\n" + "                \"" + extensionVersion + "\", // version\n" + "                WikittyUtil.tagValuesToMap(\"" + tagValues + "\"), // tag/values\n" + "                " + requires + ",\n" + "                WikittyUtil.buildFieldMapExtension( // building field map\n" + "                    " + buildFieldMapExtensionParametersInLine + "));\n" + "\n" + "        // init extensions\n" + "        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();\n" + "";
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            staticInitializationBody = staticInitializationBody + "\n        exts.addAll(" + superClass.getName() + "Abstract.extensions); \n" + "        // current after requires ones\n" + "";
        }
        staticInitializationBody = staticInitializationBody + "\n        exts.add(extension" + businessEntity.getName() + ");\n" + "        extensions = Collections.unmodifiableList(exts);\n" + "";
        this.setOperationBody(staticInitialization, staticInitializationBody);
    }

    protected void addOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(businessEntity);
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String attributeName = businessEntity.hasTagValue("alternativeName." + businessEntity.getName() + "." + attribute.getName()) ? businessEntity.getTagValue("alternativeName." + businessEntity.getName() + "." + attribute.getName()) : (attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName());
            String helperGetterSetterName = attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName();
            this.addOperationWithName(businessEntity, abstractClass, attribute, attributeName, helperClassName, helperGetterSetterName);
        }
    }

    protected void addOperationWithName(ObjectModelClass businessEntity, ObjectModelClass abstractClass, ObjectModelAttribute attribute, String getterSetterName, String helperClassName, String helperGetterSetterName) {
        String getterName;
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, true);
        String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
        String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
        String attributeObjectType = WikittyTransformerUtil.generateResultObjectType(attribute, false);
        String attributeName = attribute.getName();
        String capitalizedAttributeName = StringUtils.capitalize((String)attributeName);
        String capitalizedHelperGetterSetterName = StringUtils.capitalize((String)helperGetterSetterName);
        String capitalizedGetterSetterName = StringUtils.capitalize((String)getterSetterName);
        if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
            String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
            String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
            String attributeTypeVarargs = attributeType + "...";
            String attributeObjectTypeCollectionStrict = WikittyTransformerUtil.generateResultObjectType(attribute, true);
            String attributeObjectTypeCollectionGeneric = "Collection<" + attributeObjectType + ">";
            String attributeObjectTypeVarargs = attributeObjectType + "...";
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            getterName = "get" + capitalizedGetterSetterName;
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
            String getterBody = "\n" + attributeTypeCollectionStrict + " result = " + helperClassName + ".get" + capitalizedAttributeName + "(getWikitty());\n" + "return result;\n" + "";
            this.setOperationBody(getter, getterBody);
            String setterName = "set" + capitalizedGetterSetterName;
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
            this.addParameter(setter, attributeTypeCollectionStrict, getterSetterName);
            String setterBody = "\n" + attributeTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "();\n" + "" + helperClassName + ".set" + capitalizedHelperGetterSetterName + "(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
            this.setOperationBody(setter, setterBody);
            String addAllName = "addAll" + capitalizedGetterSetterName;
            ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClass, addAllName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAll, "Override");
            this.addParameter(addAll, attributeTypeCollectionGeneric, attributeName);
            String addAllBody = "\n" + attributeTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "();\n" + "" + helperClassName + ".addAll" + capitalizedHelperGetterSetterName + "(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
            this.setOperationBody(addAll, addAllBody);
            String addName = "add" + capitalizedGetterSetterName;
            ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClass, addName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adder, "Override");
            this.addParameter(adder, attributeTypeVarargs, "element");
            String adderBody = "\n" + attributeTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "();\n" + "" + helperClassName + ".add" + capitalizedHelperGetterSetterName + "(getWikitty(), element);\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
            this.setOperationBody(adder, adderBody);
            String removeName = "remove" + capitalizedGetterSetterName;
            ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClass, removeName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)remover, "Override");
            this.addParameter(remover, attributeTypeVarargs, "element");
            String removerBody = "\n" + attributeTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "();\n" + "" + helperClassName + ".remove" + capitalizedHelperGetterSetterName + "(getWikitty(), element);\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
            this.setOperationBody(remover, removerBody);
            String clearName = "clear" + capitalizedGetterSetterName;
            ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClass, clearName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)clear, "Override");
            String clearBody = "\n" + helperClassName + ".clear" + capitalizedHelperGetterSetterName + "(getWikitty());\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "";
            this.setOperationBody(clear, clearBody);
            if (attributeObjectType != null) {
                getterName = "get" + capitalizedGetterSetterName;
                ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeObjectTypeCollectionStrict, new ObjectModelModifier[0]);
                this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getterObject, "Override");
                String getterObjectBody = "\n" + attributeObjectTypeCollectionStrict + " result = " + helperClassName + ".get" + capitalizedAttributeName + "(getWikitty(), exceptionIfNotLoaded);\n" + "return result;\n" + "";
                this.setOperationBody(getterObject, getterObjectBody);
                String setterObjectName = "set" + capitalizedGetterSetterName + "Entity";
                ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClass, setterObjectName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setterObject, "Override");
                this.addParameter(setterObject, attributeObjectTypeCollectionGeneric, getterSetterName);
                String setterObjectBody = "\n" + attributeObjectTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "(false);\n" + "" + helperClassName + ".set" + capitalizedHelperGetterSetterName + "Entity(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(setterObject, setterObjectBody);
                String addAllNameObject = "addAll" + capitalizedGetterSetterName + "Entity";
                ObjectModelOperation addAllObject = this.addOperation((ObjectModelClassifier)abstractClass, addAllNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAllObject, "Override");
                this.addParameter(addAllObject, attributeObjectTypeCollectionGeneric, attributeName);
                String addAllObjectBody = "\n" + attributeObjectTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "(false);\n" + "" + helperClassName + ".addAll" + capitalizedHelperGetterSetterName + "Entity(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getterObject.getName() + "());\n" + "";
                this.setOperationBody(addAllObject, addAllObjectBody);
                String addNameObject = "add" + capitalizedGetterSetterName;
                ObjectModelOperation adderObject = this.addOperation((ObjectModelClassifier)abstractClass, addNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adderObject, "Override");
                this.addParameter(adderObject, attributeObjectTypeVarargs, "element");
                String adderObjectBody = "\n" + attributeObjectTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "(false);\n" + "" + helperClassName + ".add" + capitalizedHelperGetterSetterName + "(getWikitty(), element);\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getterObject.getName() + "());\n" + "";
                this.setOperationBody(adderObject, adderObjectBody);
                String removeNameObject = "remove" + capitalizedGetterSetterName;
                ObjectModelOperation removerObject = this.addOperation((ObjectModelClassifier)abstractClass, removeNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)removerObject, "Override");
                this.addParameter(removerObject, attributeObjectTypeVarargs, "element");
                String removerObjectBody = "\n" + attributeObjectTypeCollectionStrict + " oldValue = get" + capitalizedAttributeName + "(false);\n" + "" + helperClassName + ".remove" + capitalizedHelperGetterSetterName + "(getWikitty(), element);\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getterObject.getName() + "());\n" + "";
                this.setOperationBody(removerObject, removerObjectBody);
            }
        } else {
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            getterName = "get" + capitalizedGetterSetterName;
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeType, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
            this.setOperationBody(getter, "\n" + attributeType + " value = " + helperClassName + ".get" + capitalizedHelperGetterSetterName + "(getWikitty());\n" + "return value;\n" + "");
            String setterName = "set" + capitalizedGetterSetterName;
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n" + attributeType + " oldValue = " + getterName + "();\n" + "" + helperClassName + ".set" + capitalizedHelperGetterSetterName + "(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "");
            if (attributeObjectType != null) {
                getterName = "get" + capitalizedGetterSetterName;
                ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeObjectType, new ObjectModelModifier[0]);
                this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getterObject, "Override");
                this.setOperationBody(getterObject, "\n" + attributeObjectType + " value = " + helperClassName + ".get" + capitalizedHelperGetterSetterName + "(getWikitty(), exceptionIfNotLoaded);\n" + "return value;\n" + "");
                String setterNameObject = "set" + capitalizedGetterSetterName;
                ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClass, setterNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setterObject, "Override");
                this.addParameter(setterObject, attributeObjectType, attributeName);
                this.setOperationBody(setterObject, "\n" + attributeObjectType + " oldValue = " + getterName + "(false);\n" + "" + helperClassName + ".set" + capitalizedHelperGetterSetterName + "(getWikitty(), " + attributeName + ");\n" + "getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getterObject.getName() + "());\n" + "");
            }
        }
        this.attributeToGetterName.put(businessEntity.getName() + "." + attributeName, getterName);
    }

    protected void addInheritedOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        if (!this.entitiesWithInheritedOperations.contains(businessEntity)) {
            List<ObjectModelClass> superClasses = WikittyTransformerUtil.getAllSuperClasses((ObjectModel)this.model, businessEntity);
            for (ObjectModelClass superClass : superClasses) {
                superClass = ((ObjectModel)this.model).getClass(superClass.getQualifiedName());
                List<String> imports = this.requiredDependencyImports.get(businessEntity);
                if (imports == null) {
                    imports = new ArrayList<String>();
                    this.requiredDependencyImports.put(businessEntity, imports);
                }
                this.addInheritedOperations(superClass, this.processedClasses.get(superClass));
                if (!businessEntity.getPackageName().equals(superClass.getPackageName())) {
                    String parentToImport = superClass.getQualifiedName();
                    String helperToImport = superClass.getPackageName() + "." + WikittyTransformerUtil.businessEntityToHelperName(superClass);
                    this.addImport((ObjectModelClassifier)abstractClass, parentToImport);
                    this.addImport((ObjectModelClassifier)abstractClass, helperToImport);
                    imports.add(parentToImport);
                    imports.add(helperToImport);
                }
                List<String> importsNeeded = this.requiredDependencyImports.get(superClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(businessEntity + " needs imports " + importsNeeded));
                }
                if (importsNeeded != null) {
                    for (String importNeeded : importsNeeded) {
                        this.addImport((ObjectModelClassifier)abstractClass, importNeeded);
                        imports.add(importNeeded);
                    }
                }
                if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
                String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(superClass);
                for (ObjectModelAttribute attribute : superClass.getAttributes()) {
                    if (!attribute.isNavigable()) continue;
                    String attributeName = businessEntity.hasTagValue("alternativeName." + superClass.getName() + "." + attribute.getName()) ? businessEntity.getTagValue("alternativeName." + superClass.getName() + "." + attribute.getName()) : (attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName());
                    String helperGetterSetterName = attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName();
                    this.addOperationWithName(businessEntity, abstractClass, attribute, attributeName, helperClassName, helperGetterSetterName);
                }
            }
            this.entitiesWithInheritedOperations.add(businessEntity);
        }
    }

    protected void addToString(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(businessEntity);
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)abstractClass, "toString", "String", new ObjectModelModifier[0]);
        this.setDocumentation((ObjectModelElement)toString, "Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call");
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)toString, "Override");
        this.setOperationBody(toString, "\n        return " + helperClassName + ".toString(getWikitty());\n" + "");
    }

    protected void addMetaExtensionOperations(ObjectModelClass metaExtension, ObjectModelClass abstractClassForThisMetaExtension) {
        String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(metaExtension);
        ObjectModelOperation setExtensionForMetaExtension = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, "setExtensionForMetaExtension", "void", new ObjectModelModifier[0]);
        this.addParameter(setExtensionForMetaExtension, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.setDocumentation((ObjectModelElement)setExtensionForMetaExtension, String.format("add %s meta-extension on given extension to this entity", metaExtension.getName()));
        this.setOperationBody(setExtensionForMetaExtension, "\n        extensionForMetaExtension = extension;\n        " + helperClassName + ".addMetaExtension(extension, getWikitty());\n" + "");
        for (ObjectModelAttribute attribute : metaExtension.getAttributes()) {
            String getterName;
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeObjectType = WikittyTransformerUtil.generateResultObjectType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
                String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
                String attributeTypeVarargs = attributeType + "...";
                String attributeObjectTypeCollectionStrict = WikittyTransformerUtil.generateResultObjectType(attribute, true);
                String attributeObjectTypeCollectionGeneric = "Collection<" + attributeObjectType + ">";
                String attributeObjectTypeVarargs = attributeObjectType + "...";
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String attributeNameCapitalized = StringUtils.capitalize((String)attributeName);
                getterName = "get" + attributeNameCapitalized;
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getter, "Override");
                String getterBody = "\n        " + attributeTypeCollectionStrict + " result;\n" + "        if (extensionForMetaExtension == null) {\n" + "            result = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        } else {\n" + "            result = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "        }\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String setterName = "set" + attributeNameCapitalized;
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeTypeCollectionStrict, "values");
                String setterBody = "\n        String fieldName;\n        " + attributeTypeCollectionStrict + " oldValue = " + getter.getName() + "();\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + setterName + "(getWikitty(), values);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + setterName + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + attributeNameCapitalized;
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addAllName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)addAll, "Override");
                this.addParameter(addAll, attributeTypeCollectionGeneric, "values");
                String addAllBody = "\n        String fieldName;\n        " + attributeTypeCollectionStrict + " oldValue = " + getter.getName() + "();\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + addAllName + "(getWikitty(), values);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + addAllName + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + attributeNameCapitalized;
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)adder, "Override");
                this.addParameter(adder, attributeTypeVarargs, "element");
                String adderBody = "\n        String fieldName;\n        " + attributeTypeCollectionStrict + " oldValue = " + getter.getName() + "();\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + addName + "(getWikitty(), element);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + addName + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + attributeNameCapitalized;
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, removeName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)remover, "Override");
                this.addParameter(remover, attributeTypeVarargs, "element");
                String removerBody = "\n        String fieldName;\n        " + attributeTypeCollectionStrict + " oldValue = " + getter.getName() + "();\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + removeName + "(getWikitty(), element);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + removeName + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + attributeNameCapitalized;
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, clearName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)clear, "Override");
                String clearBody = "\n        String fieldName;\n        " + attributeTypeCollectionStrict + " oldValue = " + getter.getName() + "();\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + clearName + "(getWikitty());\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + clearName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(clear, clearBody);
                if (attributeObjectType == null) continue;
                getterName = "get" + attributeNameCapitalized;
                ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeObjectTypeCollectionStrict, new ObjectModelModifier[0]);
                this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getterObject, "Override");
                String getterObjectBody = "\n        " + attributeObjectTypeCollectionStrict + " result;\n" + "        if (extensionForMetaExtension == null) {\n" + "            result = " + helperClassName + "." + getterName + "(getWikitty(), exceptionIfNotLoaded);\n" + "        } else {\n" + "            result = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty(), exceptionIfNotLoaded);\n" + "        }\n" + "        return result;\n" + "";
                this.setOperationBody(getterObject, getterObjectBody);
                String setterNameObject = "set" + attributeNameCapitalized + "Entity";
                ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setterObject, "Override");
                this.addParameter(setterObject, attributeObjectTypeCollectionGeneric, "values");
                String setterBodyObject = "\n        String fieldName;\n        " + attributeObjectTypeCollectionStrict + " oldValue = " + getterObject.getName() + "(false);\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + setterNameObject + "(getWikitty(), values);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + setterNameObject + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(setterObject, setterBodyObject);
                String addAllNameObject = "addAll" + attributeNameCapitalized + "Entity";
                ObjectModelOperation addAllObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addAllNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)addAllObject, "Override");
                this.addParameter(addAllObject, attributeObjectTypeCollectionGeneric, "values");
                String addAllBodyObject = "\n        String fieldName;\n        " + attributeObjectTypeCollectionStrict + " oldValue = " + getterObject.getName() + "(false);\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + addAllNameObject + "(getWikitty(), values);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + addAllNameObject + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getterObject.getName() + "(false));\n" + "";
                this.setOperationBody(addAllObject, addAllBodyObject);
                String addNameObject = "add" + attributeNameCapitalized;
                ObjectModelOperation adderObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)adderObject, "Override");
                this.addParameter(adderObject, attributeObjectTypeVarargs, "element");
                String adderBodyObject = "\n        String fieldName;\n        " + attributeObjectTypeCollectionStrict + " oldValue = " + getterObject.getName() + "(false);\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + addNameObject + "(getWikitty(), element);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + addNameObject + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getterObject.getName() + "(false));\n" + "";
                this.setOperationBody(adderObject, adderBodyObject);
                String removeNameObject = "remove" + attributeNameCapitalized;
                ObjectModelOperation removerObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, removeNameObject, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)removerObject, "Override");
                this.addParameter(removerObject, attributeObjectTypeVarargs, "element");
                String removerBodyObject = "\n        String fieldName;\n        " + attributeObjectTypeCollectionStrict + " oldValue = " + getterObject.getName() + "(false);\n" + "        if (extensionForMetaExtension == null) {\n" + "            " + helperClassName + "." + removeNameObject + "(getWikitty(), element);\n" + "            fieldName = " + fieldVariableName + ";\n" + "        } else {\n" + "            " + helperClassName + "." + removeNameObject + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "        }\n" + "        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getterObject.getName() + "(false));\n" + "";
                this.setOperationBody(removerObject, removerBodyObject);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeType, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getter, "Override");
            this.setOperationBody(getter, "\n        " + attributeType + " value;\n" + "        if (extensionForMetaExtension == null) {\n" + "            value = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        } else {\n" + "            value = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "        }\n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setter, "Override");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue;\n" + "        if (extensionForMetaExtension == null) {\n" + "            oldValue = " + getterName + "();\n" + "            " + helperClassName + "." + setterName + "(getWikitty(), " + attributeName + ");\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "        } else {\n" + "            oldValue = " + getterName + "();\n" + "            " + helperClassName + "." + setterName + "(extensionForMetaExtension.getName(), getWikitty(), " + attributeName + ");\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "        }\n" + "");
            if (attributeObjectType == null) continue;
            getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeObjectType, new ObjectModelModifier[0]);
            this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getterObject, "Override");
            this.setOperationBody(getterObject, "\n        " + attributeObjectType + " value;\n" + "        if (extensionForMetaExtension == null) {\n" + "            value = " + helperClassName + "." + getterName + "(getWikitty(), exceptionIfNotLoaded);\n" + "        } else {\n" + "            value = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty(), exceptionIfNotLoaded);\n" + "        }\n" + "        return value;\n" + "");
            String setterNameObject = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterNameObject, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setterObject, "Override");
            this.addParameter(setterObject, attributeObjectType, attributeName);
            this.setOperationBody(setterObject, "\n        " + attributeObjectType + " oldValue;\n" + "        if (extensionForMetaExtension == null) {\n" + "            oldValue = " + getterName + "(false);\n" + "            " + helperClassName + "." + setterNameObject + "(getWikitty(), " + attributeName + ");\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getterObject.getName() + "(false));\n" + "        } else {\n" + "            oldValue = " + getterName + "(false);\n" + "            " + helperClassName + "." + setterNameObject + "(extensionForMetaExtension.getName(), getWikitty(), " + attributeName + ");\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getterObject.getName() + "(false));\n" + "        }\n" + "");
        }
    }
}

