/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyI18n;

public class WikittyI18nDTO
implements WikittyI18n {
    @WikittyField(fqn="WikittyI18n.translatableValues")
    protected Set<String> translatableValues = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyI18n.lang")
    protected Set<String> lang = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyI18n.translations")
    protected String translations;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public Set<String> getTranslatableValues() {
        return this.translatableValues;
    }

    public void setTranslatableValues(Set<String> translatableValues) {
        this.translatableValues = translatableValues == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(translatableValues);
        ++this.modificationCount;
    }

    public void addAllTranslatableValues(Set<String> translatableValues) {
        if (this.translatableValues == null) {
            this.translatableValues = new LinkedHashSet<String>();
        }
        this.translatableValues.addAll(translatableValues);
        ++this.modificationCount;
    }

    public void addTranslatableValues(String element) {
        if (this.translatableValues == null) {
            this.translatableValues = new LinkedHashSet<String>();
        }
        this.translatableValues.add(element);
        ++this.modificationCount;
    }

    public void removeTranslatableValues(String element) {
        this.translatableValues.remove(element);
        ++this.modificationCount;
    }

    public void clearTranslatableValues() {
        this.translatableValues.clear();
        ++this.modificationCount;
    }

    public Set<String> getLang() {
        return this.lang;
    }

    public void setLang(Set<String> lang) {
        this.lang = lang == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(lang);
        ++this.modificationCount;
    }

    public void addAllLang(Set<String> lang) {
        if (this.lang == null) {
            this.lang = new LinkedHashSet<String>();
        }
        this.lang.addAll(lang);
        ++this.modificationCount;
    }

    public void addLang(String element) {
        if (this.lang == null) {
            this.lang = new LinkedHashSet<String>();
        }
        this.lang.add(element);
        ++this.modificationCount;
    }

    public void removeLang(String element) {
        this.lang.remove(element);
        ++this.modificationCount;
    }

    public void clearLang() {
        this.lang.clear();
        ++this.modificationCount;
    }

    public String getTranslations() {
        return this.translations;
    }

    public void setTranslations(String translations) {
        this.translations = translations;
        ++this.modificationCount;
    }

    public WikittyI18nDTO() {
    }

    public WikittyI18nDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        Set lang;
        if (!(source instanceof WikittyI18n)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyI18n sourceCopy = (WikittyI18n)source;
        Set translatableValues = sourceCopy.getTranslatableValues();
        if (translatableValues != null) {
            this.setTranslatableValues(new LinkedHashSet<String>(translatableValues));
        }
        if ((lang = sourceCopy.getLang()) != null) {
            this.setLang(new LinkedHashSet<String>(lang));
        }
        this.setTranslations(sourceCopy.getTranslations());
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }

    public String getTranslation(String lang, String field) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTranslation(String lang, String field, String trad) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

