/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeReflector;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AnalysisRequestHandler
extends RequestHandlerBase {
    public static Logger log = LoggerFactory.getLogger(AnalysisRequestHandler.class);
    private XMLInputFactory inputFactory;
    static Map<String, String> ATTRIBUTE_MAPPING = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(CharTermAttribute.class.getName() + "#term", "value");
            this.put(OffsetAttribute.class.getName() + "#startOffset", "start");
            this.put(OffsetAttribute.class.getName() + "#endOffset", "end");
            this.put(PositionIncrementAttribute.class.getName() + "#positionIncrement", "posInc");
            this.put(TypeAttribute.class.getName() + "#type", "type");
        }
    });

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input factory: " + this.inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams != null) {
            for (ContentStream stream : req.getContentStreams()) {
                InputStream is;
                block5: {
                    Object var12_11;
                    is = null;
                    XMLStreamReader parser = null;
                    try {
                        is = stream.getStream();
                        String charset = ContentStreamBase.getCharsetFromContentType((String)stream.getContentType());
                        parser = charset == null ? this.inputFactory.createXMLStreamReader(is) : this.inputFactory.createXMLStreamReader(is, charset);
                        NamedList<Object> result = this.processContent(parser, req.getSchema());
                        rsp.add("response", result);
                        var12_11 = null;
                        if (parser == null) break block5;
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        if (parser != null) {
                            parser.close();
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                    parser.close();
                }
                IOUtils.closeQuietly((InputStream)is);
                {
                }
            }
        }
    }

    NamedList<Object> processContent(XMLStreamReader parser, IndexSchema schema) throws XMLStreamException, IOException {
        SimpleOrderedMap result = new SimpleOrderedMap();
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return result;
                }
                case 1: {
                    String currTag = parser.getLocalName();
                    if (!"doc".equals(currTag)) break;
                    log.trace("Tokenizing doc...");
                    SolrInputDocument doc = this.readDoc(parser);
                    SchemaField uniq = schema.getUniqueKeyField();
                    SimpleOrderedMap theTokens = new SimpleOrderedMap();
                    result.add(doc.getFieldValue(uniq.getName()).toString(), (Object)theTokens);
                    Iterator i$ = doc.getFieldNames().iterator();
                    block5: while (true) {
                        if (!i$.hasNext()) continue block4;
                        String name = (String)i$.next();
                        FieldType ft = schema.getFieldType(name);
                        Analyzer analyzer = ft.getAnalyzer();
                        Collection vals = doc.getFieldValues(name);
                        Iterator i$2 = vals.iterator();
                        while (true) {
                            if (!i$2.hasNext()) continue block5;
                            Object val = i$2.next();
                            StringReader reader = new StringReader(val.toString());
                            TokenStream tstream = analyzer.tokenStream(name, (Reader)reader);
                            NamedList<NamedList<Object>> tokens = AnalysisRequestHandler.getTokens(tstream);
                            theTokens.add(name, tokens);
                        }
                        break;
                    }
                }
            }
        }
    }

    static NamedList<NamedList<Object>> getTokens(TokenStream tstream) throws IOException {
        NamedList tokens = new NamedList();
        while (tstream.incrementToken()) {
            SimpleOrderedMap token = new SimpleOrderedMap();
            tokens.add("token", (Object)token);
            tstream.reflectWith(new AttributeReflector((NamedList)token){
                final /* synthetic */ NamedList val$token;
                {
                    this.val$token = namedList;
                }

                public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                    String k = attClass.getName() + '#' + key;
                    if (ATTRIBUTE_MAPPING.containsKey(k)) {
                        k = ATTRIBUTE_MAPPING.get(k);
                    }
                    this.val$token.add(k, value);
                }
            });
        }
        return tokens;
    }

    SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        StringBuilder text = new StringBuilder();
        String name = null;
        String attrName = "";
        float boost = 1.0f;
        boolean isNull = false;
        block5: while (true) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(parser.getLocalName())) {
                        return doc;
                    }
                    if (!"field".equals(parser.getLocalName()) || isNull) continue block5;
                    doc.addField(name, (Object)text.toString(), boost);
                    boost = 1.0f;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warn("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if (!"name".equals(attrName)) continue;
                        name = attrVal;
                    }
                    continue block5;
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "Provide Analysis of text";
    }

    @Override
    public String getVersion() {
        return "$Revision:$";
    }

    @Override
    public String getSourceId() {
        return "$Id:$";
    }

    @Override
    public String getSource() {
        return "$URL:$";
    }
}

