/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;

public final class NumericField
extends AbstractField {
    private final NumericTokenStream numericTS;

    public NumericField(String name) {
        this(name, 4, Field.Store.NO, true);
    }

    public NumericField(String name, Field.Store store, boolean index) {
        this(name, 4, store, index);
    }

    public NumericField(String name, int precisionStep) {
        this(name, precisionStep, Field.Store.NO, true);
    }

    public NumericField(String name, int precisionStep, Field.Store store, boolean index) {
        super(name, store, index ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO, Field.TermVector.NO);
        this.setOmitTermFreqAndPositions(true);
        this.numericTS = new NumericTokenStream(precisionStep);
    }

    public TokenStream tokenStreamValue() {
        return this.isIndexed() ? this.numericTS : null;
    }

    public byte[] getBinaryValue(byte[] result) {
        return null;
    }

    public Reader readerValue() {
        return null;
    }

    public String stringValue() {
        return this.fieldsData == null ? null : this.fieldsData.toString();
    }

    public Number getNumericValue() {
        return (Number)this.fieldsData;
    }

    public int getPrecisionStep() {
        return this.numericTS.getPrecisionStep();
    }

    public NumericField setLongValue(long value) {
        this.numericTS.setLongValue(value);
        this.fieldsData = value;
        return this;
    }

    public NumericField setIntValue(int value) {
        this.numericTS.setIntValue(value);
        this.fieldsData = value;
        return this;
    }

    public NumericField setDoubleValue(double value) {
        this.numericTS.setDoubleValue(value);
        this.fieldsData = value;
        return this;
    }

    public NumericField setFloatValue(float value) {
        this.numericTS.setFloatValue(value);
        this.fieldsData = Float.valueOf(value);
        return this;
    }
}

