/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;

class TestLoop {
    final RNG shared;
    final RNG primary;
    final int iters;
    final Fraction pshared;
    final CyclicBarrier barrier;
    final boolean[] useShared;
    final int firstidx;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;

    public TestLoop(RNG sh, RNG pri, Fraction pshr, int it, CyclicBarrier br) {
        this.shared = sh;
        this.primary = pri;
        this.pshared = pshr;
        this.iters = it;
        this.barrier = br;
        this.firstidx = (int)this.primary.get();
        int num = (int)this.pshared.numerator();
        int denom = (int)this.pshared.denominator();
        if (num == 0 || this.primary == this.shared) {
            this.useShared = new boolean[1];
            this.useShared[0] = false;
        } else if (num >= denom) {
            this.useShared = new boolean[1];
            this.useShared[0] = true;
        } else {
            int xfactor = 1024 / denom;
            if (xfactor < 1) {
                xfactor = 1;
            }
            this.useShared = new boolean[denom * xfactor];
            int i = 0;
            while (i < num * xfactor) {
                this.useShared[i] = true;
                ++i;
            }
            int i2 = num * xfactor;
            while (i2 < denom * xfactor) {
                this.useShared[i2] = false;
                ++i2;
            }
            int i3 = 1;
            while (i3 < this.useShared.length) {
                int j = (int)(this.shared.next() & Integer.MAX_VALUE) % (i3 + 1);
                boolean tmp = this.useShared[i3];
                this.useShared[i3] = this.useShared[j];
                this.useShared[j] = tmp;
                ++i3;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Runnable testLoop() {
        return new Runnable(){

            public void run() {
                int itersPerBarrier = RNG.itersPerBarrier.get();
                try {
                    try {
                        int delta = -1;
                        if (TestLoop.this.primary.getClass().equals(class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG != null ? class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG : (class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = TestLoop.class$("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG")))) {
                            delta = 2 - (int)(TestLoop.this.primary.get() % 5L);
                        }
                        Thread.currentThread().setPriority(5 + delta);
                        int nshared = (int)((double)TestLoop.this.iters * TestLoop.this.pshared.asDouble());
                        int nprimary = TestLoop.this.iters - nshared;
                        int idx = TestLoop.this.firstidx;
                        TestLoop.this.barrier.barrier();
                        int i = TestLoop.this.iters;
                        while (i > 0) {
                            ++idx;
                            if (i % itersPerBarrier == 0) {
                                TestLoop.this.primary.exchange();
                            } else {
                                RNG r;
                                if (nshared > 0 && TestLoop.this.useShared[idx % TestLoop.this.useShared.length]) {
                                    --nshared;
                                    r = TestLoop.this.shared;
                                } else {
                                    --nprimary;
                                    r = TestLoop.this.primary;
                                }
                                long rnd = r.next();
                                if (rnd % 2L == 0L && Thread.currentThread().isInterrupted()) break;
                            }
                            --i;
                        }
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    Object var3_13 = null;
                }
                catch (Throwable throwable) {
                    Object var3_14 = null;
                    try {
                        try {
                            TestLoop.this.barrier.barrier();
                        }
                        catch (BrokenBarrierException brokenBarrierException) {
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        Object v4 = null;
                    }
                }
                try {
                    try {
                        TestLoop.this.barrier.barrier();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    Object v7 = null;
                }
            }
        };
    }
}

