/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.ui.data.AbstractMappedGridDataSource;
import java.util.Map;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatDataSource
extends AbstractMappedGridDataSource<Integer, Boat> {
    private static Logger log = LoggerFactory.getLogger(BoatDataSource.class);
    private BoatFilter filter;
    private ServiceBoat service;

    public BoatDataSource(BoatFilter filter, ServiceBoat service) {
        this.filter = filter;
        this.service = service;
    }

    protected Map<Integer, Boat> execute(int startIndex, int endIndex, SortConstraint orderBy) throws WaoException {
        this.filter.setStartIndex(Integer.valueOf(startIndex));
        this.filter.setEndIndex(Integer.valueOf(endIndex));
        if (orderBy != null) {
            PropertyModel property = orderBy.getPropertyModel();
            String filterOrder = property.getPropertyName();
            ColumnSort sort = orderBy.getColumnSort();
            if (sort.equals((Object)ColumnSort.DESCENDING)) {
                filterOrder = filterOrder + " desc";
            }
            if (log.isDebugEnabled()) {
                log.debug("Order : " + filterOrder);
            }
            this.filter.setOrderBy(filterOrder);
        }
        Map boats = this.service.getBoatsByFilter(this.filter);
        this.filter.setStartIndex(null);
        this.filter.setEndIndex(null);
        return boats;
    }

    protected int count() throws WaoException {
        return this.service.getNbBoatsByFilter(this.filter);
    }

    public Class<?> getRowType() {
        return Boat.class;
    }
}

