/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
/**
 * This class is used to manage manually user select on Administration page.
 * Options need style depends on inactivity of users. So we use javascript to
 * manage dynamic states of the select. Initialization if needed (the correct
 * option to select) then use a hidden field 'hiddenUserId' to keep userId
 * context (ids are values of options).
 * This hidden field will be interpreted by Tapestry when form will be submit.
 */
AdminUserSelect = Class.create({
    initialize: function() {
        this.hiddenUserId = $('userActionsForm').hiddenUserId;
        this.userSelect = $('userActionsForm').users;
        this.userSelect.observe('change', this.updateUserId.bind(this));

        var userId = $F(this.hiddenUserId);

        // Initialize selected option
        if (userId) {
            var options = this.userSelect.select('option');
            for (i = 0; i < options.length; i++) {
                if (options[i].value == userId) {
                    options[i].selected = true;
                    break;
                }
            }
        }
        //Tapestry.debug('Initialized !');
    },
    updateUserId: function(event) {
        //Tapestry.debug('select value : ' + $F(this.userSelect));
        this.hiddenUserId.setValue($F(this.userSelect));
    }
});
