/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.cruise;

import com.google.common.base.MoreObjects;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.service.cruise.CruiseCacheAble;
import fr.ifremer.tutti.service.sampling.CruiseSamplingCache;
import fr.ifremer.tutti.service.sampling.SamplingCodeCache;
import java.io.Closeable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CruiseCache
implements CruiseCacheAble {
    private static final Log log = LogFactory.getLog(CruiseCache.class);
    private final int cruiseId;
    private final String protocolId;
    private final CruiseSamplingCache cruiseSamplingCache;
    private final SamplingCodeCache samplingCodeCache;

    public CruiseCache(Integer cruiseId, String protocolId, CruiseSamplingCache cruiseSamplingCache, SamplingCodeCache samplingCodeCache) {
        Objects.requireNonNull(cruiseId);
        Objects.requireNonNull(samplingCodeCache);
        this.cruiseId = cruiseId;
        this.protocolId = protocolId;
        this.cruiseSamplingCache = cruiseSamplingCache;
        this.samplingCodeCache = samplingCodeCache;
    }

    public boolean isCacheUpToDate(Integer cruiseId, String protocolId) {
        return Objects.equals(this.cruiseId, cruiseId) && Objects.equals(this.protocolId, protocolId);
    }

    public boolean useSamplingCache() {
        return this.cruiseSamplingCache != null;
    }

    public Integer getCruiseId() {
        return this.cruiseId;
    }

    public String getProtocolId() {
        return this.protocolId;
    }

    public Optional<CruiseSamplingCache> getSamplingCruiseCache() {
        return Optional.ofNullable(this.cruiseSamplingCache);
    }

    public SamplingCodeCache getSamplingCodeCache() {
        return this.samplingCodeCache;
    }

    @Override
    public void addIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        if (this.useSamplingCache()) {
            this.cruiseSamplingCache.addIndividualObservations(fishingOperation, individualObservations);
        }
        this.samplingCodeCache.addIndividualObservations(fishingOperation, individualObservations);
    }

    @Override
    public void removeIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        if (this.useSamplingCache()) {
            this.cruiseSamplingCache.removeIndividualObservations(fishingOperation, individualObservations);
        }
        this.samplingCodeCache.removeIndividualObservations(fishingOperation, individualObservations);
    }

    @Override
    public void addFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        if (this.useSamplingCache()) {
            this.cruiseSamplingCache.addFishingOperation(fishingOperation, individualObservations);
        }
        this.samplingCodeCache.addFishingOperation(fishingOperation, individualObservations);
    }

    @Override
    public void removeFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        if (this.useSamplingCache()) {
            this.cruiseSamplingCache.removeFishingOperation(fishingOperation, individualObservations);
        }
        this.samplingCodeCache.removeFishingOperation(fishingOperation, individualObservations);
    }

    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Closing cruise cache: " + this));
        }
        if (this.useSamplingCache()) {
            IOUtils.closeQuietly((Closeable)this.cruiseSamplingCache);
        }
        IOUtils.closeQuietly((Closeable)this.samplingCodeCache);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        if (this.cruiseSamplingCache != null) {
            toStringHelper.add("cruiseSamplingCache", (Object)this.cruiseSamplingCache);
        }
        return toStringHelper.add("samplingCodeCache", (Object)this.samplingCodeCache).toString();
    }
}

