/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportContext;
import fr.ifremer.tutti.service.catches.multipost.csv.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchBatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchBatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.FishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterWeightRowModel;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class MultiPostExportService
extends AbstractTuttiService
implements MultiPostConstants {
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected Map<String, CaracteristicQualitativeValue> sampleCategoryValueMap;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        SampleCategoryModel sampleCategoryModel = context.getSampleCategoryModel();
        this.sampleCategoryValueMap = sampleCategoryModel.toMap();
    }

    public void exportCatchBatch(File file, FishingOperation operation) {
        Integer operationId = operation.getIdAsInt();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                CatchBatchRow weights = new CatchBatchRow();
                weights.setCatchTotalWeight(catchBatch.getCatchTotalWeight());
                weights.setCatchTotalRejectedWeight(catchBatch.getCatchTotalRejectedWeight());
                weights.setSpeciesTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
                weights.setBenthosTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
                weights.setMarineLitterTotalWeight(catchBatch.getMarineLitterTotalWeight());
                this.exportOperation(weights, operation);
                exportContext.addAttachments(catchBatch.getId(), catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH);
                CatchBatchRowModel csvModel = new CatchBatchRowModel();
                exportContext.export("catchBatch.csv", csvModel, Lists.newArrayList((Object[])new CatchBatchRow[]{weights}), I18n.n((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
            }
        }
    }

    public void exportSpecies(File file, FishingOperation operation, boolean exportFrequencies, boolean exportIndividualObservations) {
        Integer operationId = operation.getIdAsInt();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                CatchWeightsRow weights = new CatchWeightsRow();
                weights.setTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
                weights.setInertWeight(catchBatch.getSpeciesTotalInertWeight());
                weights.setLivingNotItemizedWeight(catchBatch.getSpeciesTotalLivingNotItemizedWeight());
                this.exportOperation(weights, operation);
                exportContext.addAttachments(catchBatch.getId(), catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH);
                exportContext.export("weights.csv", new CatchWeightsRowModel(), Lists.newArrayList((Object[])new CatchWeightsRow[]{weights}), I18n.n((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
                BatchContainer<SpeciesBatch> speciesBatchContainer = this.persistenceService.getRootSpeciesBatch(operationId, false);
                for (SpeciesBatch batch : speciesBatchContainer.getChildren()) {
                    this.addBatch(exportContext, batch, null, exportFrequencies);
                }
                if (exportIndividualObservations) {
                    this.addIndividualObservations(exportContext, operation);
                }
                exportContext.storeSpeciesOrBenthosBatches("species.csv", exportFrequencies, exportIndividualObservations);
            }
        }
    }

    public void exportBatch(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean exportFrequencies, boolean exportIndividualObservations) {
        Integer operationId = operation.getIdAsInt();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
                if (exportFrequencies) {
                    this.addFrequencies(exportContext, speciesBatch);
                    exportContext.storeFrequencies();
                }
                if (exportIndividualObservations) {
                    this.addIndividualObservations(exportContext, speciesBatch);
                    exportContext.storeIndividualObservations();
                }
            }
        }
    }

    public void exportBenthos(File file, FishingOperation operation, boolean exportFrequencies, boolean exportIndividualObservations) {
        Integer operationId = operation.getIdAsInt();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                CatchWeightsRow weights = new CatchWeightsRow();
                weights.setTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
                weights.setInertWeight(catchBatch.getBenthosTotalInertWeight());
                weights.setLivingNotItemizedWeight(catchBatch.getBenthosTotalLivingNotItemizedWeight());
                this.exportOperation(weights, operation);
                exportContext.addAttachments(catchBatch.getId(), catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH);
                exportContext.export("weights.csv", new CatchWeightsRowModel(), Lists.newArrayList((Object[])new CatchWeightsRow[]{weights}), I18n.n((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
                BatchContainer<SpeciesBatch> benthosBatchContainer = this.persistenceService.getRootBenthosBatch(operationId, false);
                for (SpeciesBatch batch : benthosBatchContainer.getChildren()) {
                    this.addBenthos(exportContext, batch, null, exportFrequencies);
                }
                if (exportIndividualObservations) {
                    this.addIndividualObservations(exportContext, operation);
                }
                exportContext.storeSpeciesOrBenthosBatches("benthos.csv", exportFrequencies, exportIndividualObservations);
            }
        }
    }

    public void exportMarineLitter(File file, FishingOperation operation) {
        Integer operationId = operation.getIdAsInt();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                MarineLitterWeightRow weight = new MarineLitterWeightRow();
                weight.setTotalWeight(catchBatch.getMarineLitterTotalWeight());
                this.exportOperation(weight, operation);
                exportContext.export("weights.csv", new MarineLitterWeightRowModel(), Lists.newArrayList((Object[])new MarineLitterWeightRow[]{weight}), I18n.n((String)"tutti.service.multipost.export.weight.error", (Object[])new Object[0]));
                BatchContainer<MarineLitterBatch> marineLitterBatchContainer = this.persistenceService.getRootMarineLitterBatch(operationId);
                for (MarineLitterBatch batch : marineLitterBatchContainer.getChildren()) {
                    String id = this.context.generateId(MarineLitterRow.class);
                    exportContext.addMarineLitterBatch(id, batch);
                }
                exportContext.storeMarineLitterBatches();
            }
        }
    }

    public void exportAccidentalCatch(File file, FishingOperation operation) {
        try (MultiPostExportContext exportContext = new MultiPostExportContext(file, this.persistenceService);){
            FishingOperationRow foRow = new FishingOperationRow();
            this.exportOperation(foRow, operation);
            FishingOperationRowModel foRowModel = new FishingOperationRowModel();
            exportContext.export("weights.csv", foRowModel, Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}), I18n.n((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[0]));
            List<AccidentalBatch> accidentalCatches = this.persistenceService.getAllAccidentalBatch(operation.getIdAsInt());
            for (AccidentalBatch batch : accidentalCatches) {
                String id = this.context.generateId(AccidentalCatchRow.class);
                exportContext.addAccidentalCatch(id, batch);
            }
            exportContext.storeAccidentalCatches();
        }
    }

    protected void addBatch(MultiPostExportContext exportContext, SpeciesBatch batch, String parentId, boolean addFrequencies) {
        String id = this.context.generateId(CatchRow.class);
        exportContext.addSpeciesOrBenthosBatch(id, parentId, batch);
        if (addFrequencies) {
            List<SpeciesBatchFrequency> frequencies = this.getSpeciesFrequencies(batch);
            exportContext.addFrequencies(id, frequencies);
        }
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.addBatch(exportContext, child, id, addFrequencies);
        }
    }

    protected void addFrequencies(MultiPostExportContext exportContext, SpeciesBatch batch) {
        String id = this.context.generateId(CatchRow.class);
        List<SpeciesBatchFrequency> frequencies = this.getSpeciesFrequencies(batch);
        exportContext.addFrequencies(id, frequencies);
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.addFrequencies(exportContext, child);
        }
    }

    protected List<SpeciesBatchFrequency> getSpeciesFrequencies(SpeciesBatch batch) {
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getIdAsInt());
        frequencies.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(batch));
        return frequencies;
    }

    protected void addBenthos(MultiPostExportContext exportContext, SpeciesBatch batch, String parentId, boolean addFrequencies) {
        String id = this.context.generateId(CatchRow.class);
        exportContext.addSpeciesOrBenthosBatch(id, parentId, batch);
        if (addFrequencies) {
            List<SpeciesBatchFrequency> frequencies = this.getBenthosFrequencies(batch);
            exportContext.addFrequencies(id, frequencies);
        }
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.addBenthos(exportContext, child, id, addFrequencies);
        }
    }

    protected List<SpeciesBatchFrequency> getBenthosFrequencies(SpeciesBatch batch) {
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getIdAsInt());
        frequencies.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(batch));
        return frequencies;
    }

    protected void addIndividualObservations(MultiPostExportContext exportContext, FishingOperation operation) {
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatchsForFishingOperation(operation.getIdAsInt());
        for (IndividualObservationBatch batch : individualObservations) {
            String id = this.context.generateId(IndividualObservationRow.class);
            exportContext.addIndividualObservations(id, batch);
        }
    }

    protected void addIndividualObservations(MultiPostExportContext exportContext, SpeciesBatch speciesOrBenthosBatch) {
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatchsForBatch(speciesOrBenthosBatch.getIdAsInt());
        for (IndividualObservationBatch batch : individualObservations) {
            String id = this.context.generateId(IndividualObservationRow.class);
            exportContext.addIndividualObservations(id, batch);
        }
    }

    protected void exportOperation(AbstractFishingOperationRow afoRow, FishingOperation operation) {
        afoRow.setStationNumber(operation.getStationNumber());
        afoRow.setOperationNumber(operation.getFishingOperationNumber());
        afoRow.setMultirigAggregation(operation.getMultirigAggregation());
        afoRow.setDate(operation.getGearShootingStartDate());
    }
}

